/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component.CDatabaseDebuggerContainer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component.Help.CCreationDateHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component.Help.CDescriptionHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component.Help.CModificationDateHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component.Help.CNameHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component.Help.CSaveHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.CDebuggerChooserPanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.IDebuggerChooserPanelListener;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Module.Component.CNativeCallgraphViewsNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Module.Component.CNativeFunctionViewsNodeComponent;
import com.google.security.zynamics.binnavi.Gui.Progress.CDefaultProgressOperation;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.CDefaultFieldDescription;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.CStandardEditPanel;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.IInputPanelListener;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Help.CHelpButton;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.Convert;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class CModuleOverviewPanel
extends JPanel {
    private static final long serialVersionUID = 3394022635802471859L;
    private final IDatabase m_database;
    private final INaviAddressSpace m_addressSpace;
    private final INaviModule m_module;
    private final CStandardEditPanel m_stdEditPanel;
    private final CNativeFunctionViewsNodeComponent m_bottomPanel;
    private final CNativeCallgraphViewsNodeComponent m_middlePanel;
    private final CDebuggerChooserPanel m_debuggerPanel;
    private final CDatabaseDebuggerContainer m_debuggerContainer;
    private final IDebuggerChooserPanelListener m_internalDebuggerPanelListener = new InternalDebuggerChooserListener();
    private final InternalModuleListener m_moduleListener = new InternalModuleListener();
    private final UpdateListener m_updateListener = new UpdateListener();
    private final JButton m_saveButton = new CHelpButton(CActionProxy.proxy(new SaveAction()), new CSaveHelp());

    public CModuleOverviewPanel(JTree projectTree, IDatabase database, INaviAddressSpace addressSpace, INaviModule module, IViewContainer container) {
        super(new BorderLayout());
        this.m_database = database;
        this.m_module = module;
        this.m_addressSpace = addressSpace;
        CDefaultFieldDescription<String> nameInfo = new CDefaultFieldDescription<String>(module.getConfiguration().getName(), new CNameHelp());
        CDefaultFieldDescription<String> descriptionInfo = new CDefaultFieldDescription<String>(module.getConfiguration().getDescription(), new CDescriptionHelp());
        CDefaultFieldDescription<Date> creationInfo = new CDefaultFieldDescription<Date>(module.getConfiguration().getCreationDate(), new CCreationDateHelp());
        CDefaultFieldDescription<Date> modificationInfo = new CDefaultFieldDescription<Date>(module.getConfiguration().getModificationDate(), new CModificationDateHelp());
        this.m_stdEditPanel = new CStandardEditPanel("Module", nameInfo, descriptionInfo, creationInfo, modificationInfo);
        this.m_middlePanel = new CNativeCallgraphViewsNodeComponent(projectTree, this.m_module, container);
        this.m_bottomPanel = new CNativeFunctionViewsNodeComponent(projectTree, this.m_database, this.m_module, container);
        this.m_debuggerContainer = new CDatabaseDebuggerContainer(database);
        this.m_debuggerPanel = new CDebuggerChooserPanel(addressSpace, module, this.m_debuggerContainer);
        this.m_debuggerPanel.addListener(this.m_internalDebuggerPanelListener);
        module.addListener(this.m_moduleListener);
        this.createGui();
        this.m_stdEditPanel.addInputListener(this.m_updateListener);
        this.updateSaveButton();
    }

    private void createGui() {
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel innerTopPanel = new JPanel(new BorderLayout());
        topPanel.add(innerTopPanel);
        innerTopPanel.add(this.m_stdEditPanel);
        innerTopPanel.add((Component)this.m_debuggerPanel, "South");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.setBorder(new EmptyBorder(0, 0, 5, 2));
        buttonPanel.add(new JPanel());
        buttonPanel.add(this.m_saveButton);
        topPanel.add((Component)buttonPanel, "South");
        JPanel innerSp = new JPanel(new BorderLayout());
        this.m_middlePanel.setPreferredSize(new Dimension(this.m_middlePanel.getPreferredSize().width, 75));
        innerSp.add((Component)this.m_middlePanel, "North");
        innerSp.add((Component)this.m_bottomPanel, "Center");
        JSplitPane outerSp = new JSplitPane(0, true, topPanel, innerSp);
        outerSp.setOneTouchExpandable(true);
        outerSp.setDividerLocation(outerSp.getMinimumDividerLocation());
        outerSp.setResizeWeight(0.5);
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add(outerSp);
        this.add(innerPanel);
    }

    private boolean isImageBaseModified() {
        String imageBaseText = this.m_debuggerPanel.getImageBase();
        if ("".equals(imageBaseText)) {
            return true;
        }
        CAddress enteredAddress = new CAddress(Convert.hexStringToLong(imageBaseText));
        if (this.m_addressSpace == null) {
            return !enteredAddress.equals(this.m_module.getConfiguration().getImageBase());
        }
        return !enteredAddress.equals(this.m_addressSpace.getContent().getImageBase(this.m_module));
    }

    private void save() {
        String fileBaseText = this.m_debuggerPanel.getFileBase();
        if (!Convert.isHexString(fileBaseText)) {
            CMessageBox.showError(this, "Could not save original base address. Value is not a valid hexadecimal address.");
            return;
        }
        String imageBaseText = this.m_debuggerPanel.getImageBase();
        if (!Convert.isHexString(imageBaseText)) {
            CMessageBox.showError(this, "Could not save relocated base address. Value is not a valid hexadecimal address.");
            return;
        }
        new Thread(){

            @Override
            public void run() {
                CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, true);
                operation.getProgressPanel().setMaximum(5);
                operation.getProgressPanel().setText("Saving module configuration: Saving Name");
                CModuleOverviewPanel.this.saveName();
                operation.getProgressPanel().next();
                operation.getProgressPanel().setText("Saving module configuration: Saving Description");
                CModuleOverviewPanel.this.saveDescription();
                operation.getProgressPanel().next();
                operation.getProgressPanel().setText("Saving module configuration: Saving Debugger");
                CModuleOverviewPanel.this.saveDebugger();
                operation.getProgressPanel().next();
                operation.getProgressPanel().setText("Saving module configuration: Saving File Base");
                CModuleOverviewPanel.this.saveFileBase();
                operation.getProgressPanel().next();
                operation.getProgressPanel().setText("Saving module configuration: Saving Image Base");
                CModuleOverviewPanel.this.saveImageBase();
                operation.getProgressPanel().next();
                operation.stop();
                CModuleOverviewPanel.this.updateSaveButton();
            }
        }.start();
    }

    private void saveDebugger() {
        if (this.m_addressSpace == null) {
            try {
                this.m_module.getConfiguration().setDebuggerTemplate(this.m_debuggerPanel.getSelectedDebugger());
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String message2 = "E00179: Could not change the module debugger";
                String description = CUtilityFunctions.createDescription("The new module debugger could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the debugger was saved"}, new String[]{"The debugger was not saved. Please try to find out what went wrong with the database connection and try to save the debugger again."});
                NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00179: Could not change the module debugger", description, e2);
            }
        }
    }

    private void saveDescription() {
        try {
            this.m_module.getConfiguration().setDescription(this.m_stdEditPanel.getDescription());
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String message2 = "E00164: Could not change the module description";
            String description = CUtilityFunctions.createDescription("The new module description could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the module description was saved"}, new String[]{"The module description was not saved. Please try to find out what went wrong with the database connection and try to save the module description again."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00164: Could not change the module description", description, e2);
        }
    }

    private void saveFileBase() {
        try {
            CAddress fileBase = new CAddress(Convert.hexStringToLong(this.m_debuggerPanel.getFileBase()));
            this.m_module.getConfiguration().setFileBase(new CAddress(fileBase));
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String message2 = "E00165: Could not change the module file base";
            String description = CUtilityFunctions.createDescription("The new module file base could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the module file base was saved"}, new String[]{"The module file base was not saved. Please try to find out what went wrong with the database connection and try to save the module file base again."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00165: Could not change the module file base", description, e2);
        }
    }

    private void saveImageBase() {
        try {
            CAddress imageBase = new CAddress(Convert.hexStringToLong(this.m_debuggerPanel.getImageBase()));
            if (this.m_addressSpace == null) {
                this.m_module.getConfiguration().setImageBase(imageBase);
            } else {
                this.m_addressSpace.getContent().setImageBase(this.m_module, imageBase);
            }
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String message2 = "E00166: Could not change the module image base";
            String description = CUtilityFunctions.createDescription("The new module image base could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the module image base was saved"}, new String[]{"The module image base was not saved. Please try to find out what went wrong with the database connection and try to save the module image base again."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00166: Could not change the module image base", description, e2);
        }
    }

    private void saveName() {
        try {
            this.m_module.getConfiguration().setName(this.m_stdEditPanel.getNameString());
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String message2 = "E00160: Could not change the module name";
            String description = CUtilityFunctions.createDescription("The new module name could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the module name was saved"}, new String[]{"The module name was not saved. Please try to find out what went wrong with the database connection and try to save the module name again."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00160: Could not change the module name", description, e2);
        }
    }

    private void updateSaveButton() {
        String fileBaseText = this.m_debuggerPanel.getFileBase();
        boolean fileBaseChanged = "".equals(fileBaseText) || !new CAddress(Convert.hexStringToLong(fileBaseText)).equals(this.m_module.getConfiguration().getFileBase());
        boolean imageBaseChanged = this.isImageBaseModified();
        this.m_saveButton.setEnabled(!this.m_stdEditPanel.getNameString().equals(this.m_module.getConfiguration().getName()) || !this.m_stdEditPanel.getDescription().equals(this.m_module.getConfiguration().getDescription()) || fileBaseChanged || imageBaseChanged || this.m_debuggerPanel.getSelectedDebugger() != this.m_module.getConfiguration().getDebuggerTemplate());
    }

    public void dispose() {
        this.m_module.removeListener(this.m_moduleListener);
        this.m_debuggerPanel.removeListener(this.m_internalDebuggerPanelListener);
        this.m_debuggerPanel.dispose();
        if (this.m_addressSpace == null) {
            this.m_debuggerContainer.dispose();
        }
        this.m_bottomPanel.dispose();
        this.m_middlePanel.dispose();
    }

    private class UpdateListener
    implements IInputPanelListener,
    DocumentListener,
    ActionListener {
        private UpdateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CModuleOverviewPanel.this.updateSaveButton();
        }

        @Override
        public void changedInput() {
            CModuleOverviewPanel.this.updateSaveButton();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            CModuleOverviewPanel.this.updateSaveButton();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            CModuleOverviewPanel.this.updateSaveButton();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            CModuleOverviewPanel.this.updateSaveButton();
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = -5435176252593734737L;

        private SaveAction() {
            super("Save");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CModuleOverviewPanel.this.save();
        }
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void changedDescription(INaviModule module, final String description) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CModuleOverviewPanel.this.m_stdEditPanel.setDescription(description);
                }
            }.invokeLater();
        }

        @Override
        public void changedModificationDate(INaviModule module, final Date date) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CModuleOverviewPanel.this.m_stdEditPanel.setModificationDate(date);
                }
            }.invokeLater();
        }

        @Override
        public void changedName(INaviModule module, final String name) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CModuleOverviewPanel.this.m_stdEditPanel.setNameString(name);
                }
            }.invokeLater();
        }
    }

    private class InternalDebuggerChooserListener
    implements IDebuggerChooserPanelListener {
        private InternalDebuggerChooserListener() {
        }

        @Override
        public void inputChanged() {
            CModuleOverviewPanel.this.updateSaveButton();
        }
    }
}

