/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.CDataNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component.CModuleOverviewPanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Traces.Component.CTracesNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Module.Component.CModuleViewsContainerComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Module.Component.CNativeFunctionViewsNodeComponent;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.Modules.IModuleListener;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public final class CModuleNodeComponent
extends CAbstractNodeComponent {
    private static final long serialVersionUID = 7941100284678927190L;
    private static final Icon OVERVIEW_ICON = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module.png"));
    private static final Icon FUNCTIONS_ICON = new ImageIcon(CMain.class.getResource("data/projecttreeicons/native_flowgraph_views_container.png"));
    private static final Icon VIEWS_ICON = new ImageIcon(CMain.class.getResource("data/projecttreeicons/view4.png"));
    private static final Icon TRACES_ICON = new ImageIcon(CMain.class.getResource("data/projecttreeicons/debug_traces.png"));
    private static final Icon DATA_ICON = new ImageIcon(CMain.class.getResource("data/projecttreeicons/chart_curve.png"));
    private final INaviModule module;
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final CModuleOverviewPanel overviewPanel;
    private final CNativeFunctionViewsNodeComponent functionsPanel;
    private final CModuleViewsContainerComponent viewsPanel;
    private final CTracesNodeComponent tracesPanel;
    private final CDataNodeComponent dataPanel;
    private final IModuleListener internalModuleListener = new InternalModuleListener();
    private static final Map<INaviModule, CModuleNodeComponent> lookup = new HashMap<INaviModule, CModuleNodeComponent>();

    public CModuleNodeComponent(JTree projectTree, IDatabase database, INaviAddressSpace addressSpace, INaviModule module, IViewContainer container) {
        super(new BorderLayout());
        Preconditions.checkNotNull(database, "IE01977: Database argument can't be null");
        this.module = Preconditions.checkNotNull(module, "IE01978: Module argument can't be null");
        this.overviewPanel = new CModuleOverviewPanel(projectTree, database, addressSpace, module, container);
        this.tabbedPane.addTab("Overview", OVERVIEW_ICON, this.overviewPanel);
        String string2 = String.valueOf(String.format(" (%d)", module.getFunctionCount()));
        this.functionsPanel = new CNativeFunctionViewsNodeComponent(projectTree, database, module, container);
        this.tabbedPane.addTab(string2.length() != 0 ? "Functions".concat(string2) : new String("Functions"), FUNCTIONS_ICON, this.functionsPanel);
        String string3 = String.valueOf(String.format(" (%d)", module.getCustomViewCount()));
        this.viewsPanel = new CModuleViewsContainerComponent(projectTree, container);
        this.tabbedPane.addTab(string3.length() != 0 ? "Views".concat(string3) : new String("Views"), VIEWS_ICON, this.viewsPanel);
        this.tracesPanel = new CTracesNodeComponent(projectTree, container);
        this.tabbedPane.addTab("Debug Traces", TRACES_ICON, this.tracesPanel);
        this.dataPanel = new CDataNodeComponent(module, container);
        this.tabbedPane.addTab("Sections and Types", DATA_ICON, this.dataPanel);
        this.tabbedPane.setEnabledAt(1, module.isLoaded());
        this.tabbedPane.setEnabledAt(2, module.isLoaded());
        this.tabbedPane.setEnabledAt(3, module.isLoaded());
        this.tabbedPane.setEnabledAt(4, module.isLoaded());
        module.addListener(this.internalModuleListener);
        this.add(this.tabbedPane);
        lookup.put(module, this);
    }

    public static void focusSectionAddress(INaviModule module, final Section section, final long address) {
        final CModuleNodeComponent component = lookup.get(module);
        final JTabbedPane tabbedPane = component.tabbedPane;
        final Window window = SwingUtilities.getWindowAncestor(tabbedPane);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                window.toFront();
                window.repaint();
                tabbedPane.setSelectedIndex(4);
                component.dataPanel.getDataSectionComponent().scrollToSectionAddress(section, address);
            }
        });
    }

    public static void focusTypeInstance(INaviModule module, final TypeInstance instance) {
        final CModuleNodeComponent component = Preconditions.checkNotNull(lookup.get(module), "Attempting to give focus to the type window, but the CModuleNodeComponent is null.");
        final JTabbedPane tabbedPane = Preconditions.checkNotNull(component.tabbedPane, "Attempting to give focus to the type window, but the corresponding tabbed pane is null.");
        final Window window = Preconditions.checkNotNull(SwingUtilities.getWindowAncestor(tabbedPane), "Attempting to give focus to the type window, but the tabbedPane has no Window ancestor.");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                window.toFront();
                window.repaint();
                tabbedPane.setSelectedIndex(4);
                component.dataPanel.getDataSectionComponent().scrollToInstance(instance);
            }
        });
    }

    @Override
    public void dispose() {
        this.module.removeListener(this.internalModuleListener);
        this.overviewPanel.dispose();
        this.functionsPanel.dispose();
        this.viewsPanel.dispose();
        this.tracesPanel.dispose();
        this.dataPanel.dispose();
        lookup.remove(this.module);
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void addedView(INaviModule module, INaviView view) {
            String string2 = String.valueOf(String.format(" (%d)", module.getCustomViewCount()));
            CModuleNodeComponent.this.tabbedPane.setTitleAt(2, string2.length() != 0 ? "Views".concat(string2) : new String("Views"));
        }

        @Override
        public void deletedView(INaviModule module, INaviView view) {
            String string2 = String.valueOf(String.format(" (%d)", module.getCustomViewCount()));
            CModuleNodeComponent.this.tabbedPane.setTitleAt(2, string2.length() != 0 ? "Views".concat(string2) : new String("Views"));
        }

        @Override
        public void loadedModule(INaviModule module) {
            CModuleNodeComponent.this.tabbedPane.setEnabledAt(1, module.isLoaded());
            CModuleNodeComponent.this.tabbedPane.setEnabledAt(2, module.isLoaded());
            CModuleNodeComponent.this.tabbedPane.setEnabledAt(3, module.isLoaded());
            CModuleNodeComponent.this.tabbedPane.setEnabledAt(4, module.isLoaded());
        }
    }
}

