/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.disassembly.DatabaseManager;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.plugins.IModuleMenuPlugin;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CDeleteModuleAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CLoadModuleAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CModuleInitializeAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CRemoveModuleAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CResolveAllFunctionsSingleModuleAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CResolveFunctionsAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CSearchAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CSearchTableAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CStarModulesAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CToggleStarsModulesAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CUnstarModulesAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CEmptyUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CParentSelectionUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.ITreeUpdater;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.api2.IPluginInterface;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.IStaredItem;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleContainer;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CStaredItemFunctions;
import com.google.security.zynamics.zylib.gui.tables.CopySelectionAction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public final class CModuleNodeMenuBuilder
extends CAbstractMenuBuilder {
    private final DefaultMutableTreeNode m_parentNode;
    private final IDatabase m_database;
    private final INaviAddressSpace m_addressSpace;
    private final INaviModule[] m_modules;
    private CModuleContainer m_container;
    private final JTable m_table;
    private final Action m_loadModulesAction;
    private final Action m_resolveAction;
    private final Action m_resolveAllAction;
    private final Action m_searchAction;
    private final InternalModuleListener m_listener = new InternalModuleListener();
    private final Action m_initializeModuleAction;

    public CModuleNodeMenuBuilder(JTree projectTree, DefaultMutableTreeNode parentNode, IDatabase database, INaviAddressSpace addressSpace, INaviModule[] modules, JTable table) {
        super(projectTree);
        this.m_database = Preconditions.checkNotNull(database, "IE01109: Database argument can't be null");
        this.m_parentNode = parentNode;
        this.m_addressSpace = addressSpace;
        this.m_modules = (INaviModule[])modules.clone();
        this.m_table = table;
        boolean singleModule = this.m_modules.length == 1;
        this.m_loadModulesAction = CActionProxy.proxy(new CLoadModuleAction(projectTree, this.m_modules));
        this.m_initializeModuleAction = CActionProxy.proxy(new CModuleInitializeAction(projectTree, this.m_modules));
        if (singleModule) {
            this.m_container = new CModuleContainer(database, this.m_modules[0]);
            this.m_searchAction = CActionProxy.proxy(new CSearchAction(projectTree, this.m_container));
            this.m_resolveAction = CActionProxy.proxy(new CResolveFunctionsAction(projectTree, this.m_database, this.m_modules[0]));
            this.m_resolveAllAction = CActionProxy.proxy(new CResolveAllFunctionsSingleModuleAction(projectTree, this.m_database, this.m_modules[0]));
            this.updateActions(this.m_modules[0]);
            this.m_modules[0].addListener(this.m_listener);
        } else {
            this.m_searchAction = null;
            this.m_resolveAction = null;
            this.m_resolveAllAction = null;
            this.updateActions(this.m_modules);
        }
    }

    private void addPluginMenus(JComponent menu) {
        ArrayList<IModuleMenuPlugin> plugins = new ArrayList<IModuleMenuPlugin>();
        for (IPlugin<IPluginInterface> plugin : PluginInterface.instance().getPluginRegistry()) {
            if (!(plugin instanceof IModuleMenuPlugin)) continue;
            plugins.add((IModuleMenuPlugin)plugin);
        }
        boolean addedSeparator = false;
        for (IModuleMenuPlugin plugin : plugins) {
            try {
                List<JComponent> menuItems = plugin.extendModuleMenu(this.getPluginModules());
                if (menuItems == null) continue;
                for (JComponent menuItem : menuItems) {
                    if (!addedSeparator) {
                        menu.add(new JSeparator());
                        addedSeparator = true;
                    }
                    menu.add(menuItem);
                }
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
                String innerMessage = "E00093: Plugin caused an unexpected exception";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The plugin %s caused an unexpected exception.", plugin.getName()), new String[]{"The plugin contains a bug."}, new String[]{"The plugin probably behaves erroneously from this point on but it remains active"});
                NaviErrorDialog.show(this.getParent(), "E00093: Plugin caused an unexpected exception", innerDescription, exception);
            }
        }
    }

    private ITreeUpdater getParentUpdater() {
        return this.m_parentNode == null ? new CEmptyUpdater() : new CParentSelectionUpdater(this.getProjectTree(), this.m_parentNode);
    }

    private List<Module> getPluginModules() {
        DatabaseManager manager = PluginInterface.instance().getDatabaseManager();
        for (Database database : manager) {
            if (database.getNative() != this.m_database) continue;
            List<Module> allModules = database.getModules();
            ArrayList<Module> menuModules = new ArrayList<Module>();
            for (INaviModule module : this.m_modules) {
                menuModules.add(ObjectFinders.getObject(module, allModules));
            }
            return menuModules;
        }
        throw new IllegalStateException("IE01165: Unknown database");
    }

    private void updateActions(INaviModule module) {
        this.m_loadModulesAction.putValue("Name", CLoadModuleAction.generateActionString(module));
        this.m_loadModulesAction.setEnabled(module.getConfiguration().getRawModule().isComplete() && !module.isLoaded());
        this.m_initializeModuleAction.setEnabled(!module.isInitialized() && module.getConfiguration().getRawModule().isComplete());
        this.m_resolveAction.setEnabled(module.isLoaded());
        this.m_resolveAllAction.setEnabled(module.isLoaded());
        this.m_searchAction.setEnabled(module.isLoaded());
    }

    private void updateActions(INaviModule[] m_modules) {
        for (INaviModule module : m_modules) {
            if (!module.isInitialized()) continue;
            this.m_initializeModuleAction.setEnabled(false);
            return;
        }
        this.m_initializeModuleAction.setEnabled(true);
    }

    @Override
    protected void createMenu(JComponent menu) {
        menu.add(new JMenuItem(this.m_loadModulesAction));
        menu.add(new JMenuItem(this.m_initializeModuleAction));
        menu.add(new JSeparator());
        if (CStaredItemFunctions.allStared((IStaredItem[])this.m_modules)) {
            menu.add(new JMenuItem(CActionProxy.proxy(new CUnstarModulesAction(this.getParent(), this.m_modules))));
        } else if (CStaredItemFunctions.allNotStared((IStaredItem[])this.m_modules)) {
            menu.add(new JMenuItem(CActionProxy.proxy(new CStarModulesAction(this.getParent(), this.m_modules))));
        } else {
            menu.add(new JMenuItem(CActionProxy.proxy(new CToggleStarsModulesAction(this.getParent(), this.m_modules))));
        }
        if (this.m_modules.length == 1) {
            menu.add(new JSeparator());
            menu.add(new JMenuItem(this.m_searchAction));
            menu.add(new JMenuItem(this.m_resolveAction));
            menu.add(new JMenuItem(this.m_resolveAllAction));
        }
        menu.add(new JSeparator());
        if (this.m_addressSpace == null) {
            menu.add(new JMenuItem(CActionProxy.proxy(new CDeleteModuleAction(this.getParent(), this.m_database, this.m_modules, this.getParentUpdater()))));
        } else {
            menu.add(new JMenuItem(CActionProxy.proxy(new CRemoveModuleAction(this.getParent(), this.m_addressSpace, this.m_modules))));
        }
        if (this.m_table != null) {
            menu.add(new JSeparator());
            menu.add(new JMenuItem(CActionProxy.proxy(new CSearchTableAction(this.getParent(), this.m_table))));
            menu.add(new JMenuItem(CActionProxy.proxy(new CopySelectionAction(this.m_table))));
        }
        this.addPluginMenus(menu);
    }

    @Override
    protected JMenu getMenu() {
        JMenu menu = new JMenu("Module");
        menu.setMnemonic("HK_MENU_MODULE".charAt(0));
        return menu;
    }

    @Override
    public void dispose() {
        if (this.m_modules.length == 1) {
            this.m_container.dispose();
            this.m_modules[0].removeListener(this.m_listener);
        }
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void loadedModule(INaviModule module) {
            CModuleNodeMenuBuilder.this.updateActions(module);
        }

        @Override
        public void initializedModule(INaviModule module) {
            CModuleNodeMenuBuilder.this.updateActions(module);
        }
    }
}

