/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.DebuggerContainer.Component;

import com.google.common.primitives.Ints;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CDatabaseFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Debugger.CDebuggerNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.DebuggerContainer.Component.CDebuggersModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.DebuggerContainer.Component.Help.CDebuggersTableHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CEmptyUpdater;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public final class CDebuggersTable
extends CAbstractTreeTable<DebuggerTemplate> {
    private static final long serialVersionUID = 5075738529815870485L;
    private final IDatabase m_database;

    public CDebuggersTable(JTree projectTree, IDatabase database) {
        super(projectTree, new CDebuggersModel(database), new CDebuggersTableHelp());
        this.m_database = database;
    }

    private DebuggerTemplate[] getDebuggers(int[] sortSelectedRows) {
        DebuggerTemplate[] projects = new DebuggerTemplate[sortSelectedRows.length];
        for (int i2 = 0; i2 < projects.length; ++i2) {
            projects[i2] = this.m_database.getContent().getDebuggerTemplateManager().getDebugger(sortSelectedRows[i2]);
        }
        return projects;
    }

    private DebuggerTemplate[] getSelectedDebuggers(int sortedRow) {
        int[] sortSelectedRows = this.getSortSelectedRows();
        if (Ints.asList(sortSelectedRows).indexOf(sortedRow) != -1) {
            return this.getDebuggers(sortSelectedRows);
        }
        int viewRow = this.convertRowIndexToView(sortedRow);
        this.setRowSelectionInterval(viewRow, viewRow);
        return new DebuggerTemplate[]{this.m_database.getContent().getDebuggerTemplateManager().getDebugger(sortedRow)};
    }

    @Override
    protected void deleteRows() {
        CDatabaseFunctions.deleteDebuggers(this.getParentWindow(), this.m_database, this.getDebuggers(this.getSortSelectedRows()), new CEmptyUpdater());
    }

    @Override
    protected JPopupMenu getPopupMenu(int x2, int y2, int row) {
        CDebuggerNodeMenuBuilder menu = new CDebuggerNodeMenuBuilder(this.getProjectTree(), null, this, this.m_database, this.getSelectedDebuggers(row));
        return menu.getPopupMenu();
    }

    @Override
    protected void handleDoubleClick(int row) {
    }
}

