/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.DebuggerContainer.Component;

import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CTablePanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.DebuggerContainer.Component.CDebuggersTable;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateManagerListener;
import javax.swing.JTree;

public final class CDebuggerContainerNodeComponent
extends CTablePanel<DebuggerTemplate> {
    private static final long serialVersionUID = 1427827839135966321L;
    private final IDatabase m_database;
    private final InternalDebuggerDescriptionManagerListener m_listener;

    public CDebuggerContainerNodeComponent(JTree projectTree, IDatabase database) {
        super(new CDebuggersTable(projectTree, database), null, null);
        this.m_database = database;
        this.m_listener = new InternalDebuggerDescriptionManagerListener();
        this.m_database.getContent().getDebuggerTemplateManager().addListener(this.m_listener);
        this.updateBorderText(this.getBorderText());
    }

    private String getBorderText() {
        return String.format("%d Debuggers in Database '%s'", this.m_database.getContent().getDebuggerTemplateManager().debuggerCount(), this.m_database.getConfiguration().getDescription());
    }

    @Override
    protected void disposeInternal() {
        this.m_database.getContent().getDebuggerTemplateManager().removeListener(this.m_listener);
    }

    private class InternalDebuggerDescriptionManagerListener
    implements IDebuggerTemplateManagerListener {
        private InternalDebuggerDescriptionManagerListener() {
        }

        @Override
        public void addedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            CDebuggerContainerNodeComponent.this.updateBorderText(CDebuggerContainerNodeComponent.this.getBorderText());
        }

        @Override
        public void removedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            CDebuggerContainerNodeComponent.this.updateBorderText(CDebuggerContainerNodeComponent.this.getBorderText());
        }
    }
}

