/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.DebuggerContainer;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Debugger.CDebuggerNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.DebuggerContainer.CDebuggerContainerNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.DebuggerContainer.Component.CDebuggerContainerNodeComponent;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateManagerListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;

public final class CDebuggerContainerNode
extends CProjectTreeNode<Object> {
    private static final long serialVersionUID = 7942293319476781440L;
    private static final ImageIcon ICON_DEBUGGER_CONTAINER = new ImageIcon(CMain.class.getResource("data/projecttreeicons/debugger_container2.png"));
    private final IDatabase m_database;
    private final InternalDebuggerTemplateManagerListener m_debuggerManagerListener = new InternalDebuggerTemplateManagerListener();

    public CDebuggerContainerNode(final JTree projectTree, final IDatabase database) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CDebuggerContainerNodeComponent(projectTree, database);
            }
        }, new CDebuggerContainerNodeMenuBuilder(projectTree, database));
        this.m_database = Preconditions.checkNotNull(database, "IE01968: Database can't be null");
        this.m_database.getContent().getDebuggerTemplateManager().addListener(this.m_debuggerManagerListener);
        this.createChildren();
    }

    @Override
    protected void createChildren() {
        if (this.m_database.isLoaded()) {
            for (DebuggerTemplate debugger : this.m_database.getContent().getDebuggerTemplateManager()) {
                this.add(new CDebuggerNode(this.getProjectTree(), this, this.m_database, debugger));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        DebuggerTemplateManager debuggerManager = this.m_database.getContent().getDebuggerTemplateManager();
        debuggerManager.removeListener(this.m_debuggerManagerListener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    public Icon getIcon() {
        return ICON_DEBUGGER_CONTAINER;
    }

    @Override
    public String toString() {
        String string2 = String.valueOf("Debuggers (");
        int n2 = this.m_database.getContent().getDebuggerTemplateManager().debuggerCount();
        return new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(n2).append(")").toString();
    }

    private class InternalDebuggerTemplateManagerListener
    implements IDebuggerTemplateManagerListener {
        private InternalDebuggerTemplateManagerListener() {
        }

        @Override
        public void addedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            CDebuggerContainerNode.this.add(new CDebuggerNode(CDebuggerContainerNode.this.getProjectTree(), CDebuggerContainerNode.this, CDebuggerContainerNode.this.m_database, debugger));
            CDebuggerContainerNode.this.getTreeModel().nodeStructureChanged(CDebuggerContainerNode.this);
        }

        @Override
        public void removedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            for (int i2 = 0; i2 < CDebuggerContainerNode.this.getChildCount(); ++i2) {
                CDebuggerNode node = (CDebuggerNode)CDebuggerContainerNode.this.getChildAt(i2);
                if (node.getObject() != debugger) continue;
                node.dispose();
                CDebuggerContainerNode.this.remove(node);
                break;
            }
            CDebuggerContainerNode.this.getTreeModel().nodeStructureChanged(CDebuggerContainerNode.this);
        }
    }
}

