/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Debugger.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.CLabeledComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Debugger.Component.Help.CHostHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Debugger.Component.Help.CNameHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Debugger.Component.Help.CPortHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Debugger.Component.Help.CSaveHelp;
import com.google.security.zynamics.binnavi.Gui.SaveFields.CSaveField;
import com.google.security.zynamics.binnavi.Gui.SaveFields.CSaveFormattedField;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Help.CHelpButton;
import com.google.security.zynamics.binnavi.Help.CHelpSaveField;
import com.google.security.zynamics.binnavi.Help.CHelpSaveFormattedField;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateListener;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class CDebuggerNodeComponent
extends CAbstractNodeComponent {
    private static final long serialVersionUID = 1348721039872070862L;
    private final DebuggerTemplate m_debugger;
    private final CSaveField m_nameTextField;
    private final CSaveField m_hostTextField;
    private final CSaveFormattedField m_portTextField;
    private final InternalDebuggerDescriptionListener m_listener = new InternalDebuggerDescriptionListener();
    private final JButton m_saveButton = new CHelpButton(CActionProxy.proxy(new SaveAction()), new CSaveHelp());

    public CDebuggerNodeComponent(DebuggerTemplate debugger) {
        super(new BorderLayout());
        this.m_debugger = Preconditions.checkNotNull(debugger, "IE01967: Debugger argument can't be null");
        this.m_nameTextField = new CHelpSaveField(debugger.getName(), new CNameHelp());
        this.m_hostTextField = new CHelpSaveField(debugger.getHost(), new CHostHelp());
        this.m_portTextField = new CHelpSaveFormattedField(new CDecFormatter(5), (IHelpInformation)new CPortHelp());
        this.m_portTextField.setText(String.valueOf(debugger.getPort()));
        this.m_debugger.addListener(this.m_listener);
        this.createGui();
        UpdateListener updateListener = new UpdateListener();
        this.m_nameTextField.getDocument().addDocumentListener(updateListener);
        this.m_hostTextField.getDocument().addDocumentListener(updateListener);
        this.m_portTextField.getDocument().addDocumentListener(updateListener);
        this.updateGui();
    }

    private void createGui() {
        JPanel basePanel = new JPanel(new BorderLayout());
        JPanel titledBorderHelperPanel = new JPanel(new BorderLayout());
        titledBorderHelperPanel.setBorder(new TitledBorder("Debugger"));
        JPanel containerPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        containerPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.setBorder(new EmptyBorder(5, 0, 5, 2));
        buttonPanel.add(new JPanel());
        buttonPanel.add(this.m_saveButton);
        containerPanel.add(new CLabeledComponent("Name:", new CNameHelp(), this.m_nameTextField));
        containerPanel.add(new CLabeledComponent("Host:", new CHostHelp(), this.m_hostTextField));
        containerPanel.add(new CLabeledComponent("Port:", new CPortHelp(), this.m_portTextField));
        titledBorderHelperPanel.add((Component)containerPanel, "North");
        basePanel.add((Component)titledBorderHelperPanel, "North");
        basePanel.add((Component)buttonPanel, "Center");
        this.add((Component)basePanel, "North");
    }

    private void save() {
        String description;
        String message2;
        try {
            this.m_debugger.setName(this.m_nameTextField.getText());
        }
        catch (CouldntSaveDataException exception) {
            CUtilityFunctions.logException(exception);
            message2 = "E00053: Could not save the new debugger name";
            description = CUtilityFunctions.createDescription("The new debugger name could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the debugger name was saved"}, new String[]{"The debugger name was not saved. Please try to find out what went wrong with the database connection and try to save the debugger name again."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00053: Could not save the new debugger name", description, exception);
        }
        try {
            this.m_debugger.setHost(this.m_hostTextField.getText());
        }
        catch (CouldntSaveDataException exception) {
            CUtilityFunctions.logException(exception);
            message2 = "E00158: Could not save the new debugger description";
            description = CUtilityFunctions.createDescription("The new debugger description could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the debugger description was saved"}, new String[]{"The debugger description was not saved. Please try to find out what went wrong with the database connection and try to save the debugger description again."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00158: Could not save the new debugger description", description, exception);
        }
        try {
            this.m_debugger.setPort(Integer.parseInt(this.m_portTextField.getText()));
        }
        catch (CouldntSaveDataException exception) {
            CUtilityFunctions.logException(exception);
            message2 = "E00159: Could not save the new debugger port";
            description = CUtilityFunctions.createDescription("The new debugger port could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the debugger port was saved"}, new String[]{"The debugger port was not saved. Please try to find out what went wrong with the database connection and try to save the debugger port again."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00159: Could not save the new debugger port", description, exception);
        }
    }

    private void updateGui() {
        boolean nameModified = !this.m_nameTextField.getText().equals(this.m_debugger.getName());
        boolean hostModified = !this.m_hostTextField.getText().equals(this.m_debugger.getHost());
        boolean portModified = !this.m_portTextField.getText().equals(String.valueOf(this.m_debugger.getPort()));
        this.m_saveButton.setEnabled(nameModified || hostModified || portModified);
        this.m_nameTextField.setModified(nameModified);
        this.m_hostTextField.setModified(hostModified);
        this.m_portTextField.setModified(portModified);
    }

    @Override
    public void dispose() {
        this.m_debugger.removeListener(this.m_listener);
    }

    private class UpdateListener
    implements DocumentListener {
        private UpdateListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            CDebuggerNodeComponent.this.updateGui();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            CDebuggerNodeComponent.this.updateGui();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            CDebuggerNodeComponent.this.updateGui();
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 8909931652747685283L;

        private SaveAction() {
            super("Save");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CDebuggerNodeComponent.this.save();
        }
    }

    private class InternalDebuggerDescriptionListener
    implements IDebuggerTemplateListener {
        private InternalDebuggerDescriptionListener() {
        }

        @Override
        public void changedHost(DebuggerTemplate debugger) {
            CDebuggerNodeComponent.this.m_hostTextField.setText(debugger.getHost());
            CDebuggerNodeComponent.this.updateGui();
        }

        @Override
        public void changedName(DebuggerTemplate debugger) {
            CDebuggerNodeComponent.this.m_nameTextField.setText(debugger.getName());
            CDebuggerNodeComponent.this.updateGui();
        }

        @Override
        public void changedPort(DebuggerTemplate debugger) {
            CDebuggerNodeComponent.this.m_portTextField.setText(String.valueOf(debugger.getPort()));
            CDebuggerNodeComponent.this.updateGui();
        }
    }
}

