/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Debugger;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Debugger.CDebuggerNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Debugger.Component.CDebuggerNodeComponent;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public final class CDebuggerNode
extends CProjectTreeNode<DebuggerTemplate> {
    private static final long serialVersionUID = 4377093985630890630L;
    private static final ImageIcon ICON_DEBUGGER = new ImageIcon(CMain.class.getResource("data/projecttreeicons/debugger3.png"));
    private final DebuggerTemplate m_debugger;
    private final InternalDebuggerDescriptionListener m_listener = new InternalDebuggerDescriptionListener();

    public CDebuggerNode(JTree projectTree, DefaultMutableTreeNode parentNode, IDatabase database, final DebuggerTemplate debugger) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CDebuggerNodeComponent(debugger);
            }
        }, new CDebuggerNodeMenuBuilder(projectTree, parentNode, null, database, new DebuggerTemplate[]{debugger}), debugger);
        Preconditions.checkNotNull(database, "IE01965: Database argument can not be null.");
        this.m_debugger = Preconditions.checkNotNull(debugger, "IE01966: Debugger argument can not be null");
        this.m_debugger.addListener(this.m_listener);
    }

    @Override
    protected void createChildren() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_debugger.removeListener(this.m_listener);
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    public Icon getIcon() {
        return ICON_DEBUGGER;
    }

    @Override
    public String toString() {
        return this.m_debugger.getName();
    }

    private class InternalDebuggerDescriptionListener
    implements IDebuggerTemplateListener {
        private InternalDebuggerDescriptionListener() {
        }

        @Override
        public void changedHost(DebuggerTemplate debugger) {
        }

        @Override
        public void changedName(DebuggerTemplate debugger) {
            CDebuggerNode.this.getTreeModel().nodeChanged(CDebuggerNode.this);
        }

        @Override
        public void changedPort(DebuggerTemplate debugger) {
        }
    }
}

