/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeComboBox;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeListModel;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TypeInstanceDialog
extends JDialog {
    private static final long serialVersionUID = -7912640983889588677L;
    private JTextField instanceName;
    private TypeComboBox types;
    private boolean okClicked;
    private JTextField sectionOffset;
    private final Section section;
    private static Long sanitizedOffset;

    private TypeInstanceDialog(JFrame owner, String dialogTitle, TypeListModel model, TypeInstance instance, Section section, Long offset) {
        super(owner, dialogTitle, true);
        this.section = section;
        this.createControls(model);
        this.populateControls(instance, offset);
    }

    private static boolean isValidSectionOffset(JTextField textField, Section section) {
        Preconditions.checkNotNull(textField, "Error: textField argument can not be null");
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        if (textField.getText().isEmpty()) {
            return false;
        }
        try {
            Long offset;
            String textFieldString = textField.getText().toLowerCase();
            boolean hex = false;
            if (textFieldString.startsWith("0x")) {
                textFieldString = textFieldString.substring(2);
                hex = true;
            }
            if (section.isValidOffset(offset = Long.valueOf(textFieldString.matches("^[0-9A-Fa-f]+$") && hex ? Long.parseLong(textFieldString, 16) : Long.parseLong(textFieldString, 10)))) {
                sanitizedOffset = offset;
                return true;
            }
            if (section.isValidAddress(offset)) {
                sanitizedOffset = offset - section.getStartAddress().toLong();
                return true;
            }
            return false;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }

    public static TypeInstanceDialog instantiateCreateTypeInstanceDialog(JFrame owner, TypeManager typeManager, Section section, Long offset) {
        return new TypeInstanceDialog(owner, "Create type instance", new TypeListModel(typeManager.getTypes(), new TypeListModel.PrototypesFilter()), null, section, offset);
    }

    public static TypeInstanceDialog instantiateEditTypeInstanceDialog(JFrame owner, TypeManager typeManager, TypeInstance instance) {
        TypeInstanceDialog dialog = new TypeInstanceDialog(owner, "Edit type instance", new TypeListModel(typeManager.getTypes(), new TypeListModel.PrototypesFilter()), instance, instance.getSection(), instance.getAddress().getOffset());
        dialog.types.setEnabled(false);
        dialog.sectionOffset.setEnabled(false);
        return dialog;
    }

    private void createControls(TypeListModel model) {
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (TypeInstanceDialog.this.validateUserInput()) {
                    TypeInstanceDialog.this.okClicked = true;
                    TypeInstanceDialog.this.dispose();
                }
            }
        });
        panel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TypeInstanceDialog.this.dispose();
            }
        });
        panel.add(cancelButton);
        this.types = new TypeComboBox(model);
        this.getContentPane().add((Component)this.types, "Center");
        JPanel panel_1 = new JPanel();
        this.getContentPane().add((Component)panel_1, "North");
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{166, 109, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 15, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JLabel lblInstanceName_1 = new JLabel("Instance name:");
        GridBagConstraints gbc_lblInstanceName_1 = new GridBagConstraints();
        gbc_lblInstanceName_1.anchor = 17;
        gbc_lblInstanceName_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblInstanceName_1.gridx = 0;
        gbc_lblInstanceName_1.gridy = 0;
        panel_1.add((Component)lblInstanceName_1, gbc_lblInstanceName_1);
        this.instanceName = new JTextField();
        GridBagConstraints gbc_instanceName = new GridBagConstraints();
        gbc_instanceName.insets = new Insets(0, 0, 5, 0);
        gbc_instanceName.fill = 2;
        gbc_instanceName.gridx = 1;
        gbc_instanceName.gridy = 0;
        panel_1.add((Component)this.instanceName, gbc_instanceName);
        this.instanceName.setColumns(10);
        JLabel lblSectionOffset = new JLabel("Section offset:");
        GridBagConstraints gbc_lblSectionOffset = new GridBagConstraints();
        gbc_lblSectionOffset.anchor = 17;
        gbc_lblSectionOffset.insets = new Insets(0, 0, 5, 5);
        gbc_lblSectionOffset.gridx = 0;
        gbc_lblSectionOffset.gridy = 1;
        panel_1.add((Component)lblSectionOffset, gbc_lblSectionOffset);
        this.sectionOffset = new JTextField();
        GridBagConstraints gbc_sectionOffset = new GridBagConstraints();
        gbc_sectionOffset.insets = new Insets(0, 0, 5, 0);
        gbc_sectionOffset.fill = 2;
        gbc_sectionOffset.gridx = 1;
        gbc_sectionOffset.gridy = 1;
        panel_1.add((Component)this.sectionOffset, gbc_sectionOffset);
        this.sectionOffset.setColumns(10);
        this.pack();
        new CDialogEscaper(this);
    }

    private void populateControls(TypeInstance instance, Long offset) {
        if (instance != null) {
            this.instanceName.setText(instance.getName());
            this.types.getModel().selectByBaseType(instance.getBaseType());
        }
        if (offset != null) {
            this.sectionOffset.setText(String.valueOf(offset));
        }
    }

    private boolean validateUserInput() {
        if (this.getInstanceType() == null || this.getInstanceName() == null) {
            CMessageBox.showWarning(this, "Please enter a name for the type instance and select a base type.");
            return false;
        }
        if (!TypeInstanceDialog.isValidSectionOffset(this.sectionOffset, this.section)) {
            CMessageBox.showWarning(this, String.format("Please enter a valid section offset!\n The valid range for '%s' is [0x%X-0x%X).", this.section.getName(), this.section.getStartAddress().toLong(), this.section.getEndAddress().toLong()));
            return false;
        }
        return true;
    }

    public String getInstanceName() {
        return this.instanceName.getText();
    }

    public BaseType getInstanceType() {
        return (BaseType)this.types.getSelectedItem();
    }

    public long getSectionOffset() {
        return sanitizedOffset;
    }

    public boolean wasOkClicked() {
        return this.okClicked;
    }
}

