/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.LoadPanel.Implementations;

import com.google.common.io.ByteStreams;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import java.awt.Window;
import java.io.FileInputStream;
import java.io.IOException;

public final class CDataFunctions {
    private CDataFunctions() {
    }

    public static void loadFromDatabase(Window parent, INaviModule module) {
        LoadFromDatabaseThread thread2 = new LoadFromDatabaseThread(module);
        CProgressDialog.showEndless(parent, "Loading data from the database ...", thread2);
        Exception exception = thread2.getException();
        if (exception != null) {
            CUtilityFunctions.logException(exception);
            String message2 = "E00199: Could not load module data";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not load the module data of module '%s' from the database.", module.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The module data was not loaded from the database."});
            NaviErrorDialog.show(parent, "E00199: Could not load module data", description, exception);
        }
    }

    public static void loadFromFile(Window parent, INaviModule module, String filename) {
        try {
            byte[] data = ByteStreams.toByteArray(new FileInputStream(filename));
            module.setData(data);
        }
        catch (IOException exception) {
            CUtilityFunctions.logException(exception);
            String message2 = "E00207: Could not load module data from file";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not load the data of file '%s'.", filename), new String[]{"There was a problem reading the file."}, new String[]{"The module data was not loaded."});
            NaviErrorDialog.show(parent, "E00207: Could not load module data from file", description, exception);
        }
    }

    public static void storeData(Window parent, INaviModule module) {
        SaveToDatabaseThread thread2 = new SaveToDatabaseThread(module);
        CProgressDialog.showEndless(parent, "Saving data to the database ...", thread2);
        Exception exception = thread2.getException();
        if (exception != null) {
            CUtilityFunctions.logException(exception);
            String message2 = "E00200: Could not save module data";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not save the module data of module '%s' to the database.", module.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The module data was not written to the database."});
            NaviErrorDialog.show(parent, "E00200: Could not save module data", description, exception);
        }
    }

    private static class SaveToDatabaseThread
    extends CEndlessHelperThread {
        private final INaviModule m_module;

        public SaveToDatabaseThread(INaviModule module) {
            this.m_module = module;
        }

        @Override
        protected void runExpensiveCommand() throws Exception {
            this.m_module.saveData();
        }
    }

    private static class LoadFromDatabaseThread
    extends CEndlessHelperThread {
        private final INaviModule m_module;

        public LoadFromDatabaseThread(INaviModule module) {
            this.m_module = module;
        }

        @Override
        protected void runExpensiveCommand() throws Exception {
            this.m_module.loadData();
        }
    }
}

