/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.LoadPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.LoadPanel.Implementations.CDataFunctions;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.gui.CFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class CLoadPanel
extends JPanel {
    private static final long serialVersionUID = -3363342903629907902L;
    private final JButton m_storeButton;

    public CLoadPanel(INaviModule module) {
        Preconditions.checkNotNull(module, "IE01961: Module argument can not be null");
        this.m_storeButton = new JButton(CActionProxy.proxy(new CStoreAction(module)));
        this.setLayout(new BorderLayout());
        JPanel innerPanelLeft = new JPanel(new BorderLayout());
        innerPanelLeft.add((Component)new JButton(CActionProxy.proxy(new CLoadDatabaseAction(module))), "West");
        this.add((Component)innerPanelLeft, "West");
        JPanel innerPanel = new JPanel(new BorderLayout());
        JPanel loadButtonPanel = new JPanel(new BorderLayout());
        loadButtonPanel.setBorder(new EmptyBorder(0, 0, 0, 3));
        loadButtonPanel.add((Component)new JButton(CActionProxy.proxy(new CLoadAction(module))), "Center");
        innerPanel.add((Component)loadButtonPanel, "West");
        innerPanel.add((Component)this.m_storeButton, "East");
        this.add((Component)innerPanel, "East");
        this.setBorder(new TitledBorder("Data Options"));
    }

    private static String selectAssociatedFile(Window parent) {
        CFileChooser chooser = new CFileChooser();
        chooser.setDialogTitle("Select the input file");
        if (chooser.showOpenDialog(parent) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public void dispose() {
    }

    private class CStoreAction
    extends AbstractAction {
        private static final long serialVersionUID = -7058938411200766428L;
        private final INaviModule m_module;

        public CStoreAction(INaviModule module) {
            super("Store");
            this.m_module = module;
            this.putValue("SmallIcon", new ImageIcon(CMain.class.getResource("data/save_to_database.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CDataFunctions.storeData(SwingUtilities.getWindowAncestor(CLoadPanel.this), this.m_module);
        }
    }

    private class CLoadDatabaseAction
    extends AbstractAction {
        private static final long serialVersionUID = 6407054355352505148L;
        private final INaviModule m_module;

        public CLoadDatabaseAction(INaviModule module) {
            super("Load");
            this.m_module = module;
            this.putValue("SmallIcon", new ImageIcon(CMain.class.getResource("data/load_from_database.png")));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CDataFunctions.loadFromDatabase(SwingUtilities.getWindowAncestor(CLoadPanel.this), this.m_module);
        }
    }

    private class CLoadAction
    extends AbstractAction {
        private static final long serialVersionUID = 4173682656470933076L;
        private final INaviModule m_module;

        public CLoadAction(INaviModule module) {
            super("Load");
            this.putValue("SmallIcon", new ImageIcon(CMain.class.getResource("data/folder.png")));
            this.m_module = module;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String filename = CLoadPanel.selectAssociatedFile(SwingUtilities.getWindowAncestor(CLoadPanel.this));
            if (filename != null) {
                CDataFunctions.loadFromFile(SwingUtilities.getWindowAncestor(CLoadPanel.this), this.m_module, filename);
            }
        }
    }
}

