/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.CreateTypeInstanceAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.DeleteTypeInstanceAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.EditTypeInstanceAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.HexViewOptionsMenu;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.SectionComboBox;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.TypeInstanceAddressTableCellRenderer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.TypeInstanceTableDatamodel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Views.Component.Actions.OpenInLastWindowAndZoomToAddressAction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceAddress;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainerListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplay;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplayCoordinate;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplayEventListener;
import com.google.security.zynamics.zylib.gui.JHexPanel.IDataChangedListener;
import com.google.security.zynamics.zylib.gui.JHexPanel.IDataProvider;
import com.google.security.zynamics.zylib.gui.JHexPanel.IMenuCreator;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class DataSectionComponent
extends JPanel {
    private static final int SELECTED_INSTANCE_HIGHLIGHT_LEVEL = 4;
    private static final int DEFAULT_INSTANCE_HIGHLIGHT_LEVEL = 5;
    private volatile HexViewDataAdapter hexViewData;
    private volatile Section currentSection;
    private volatile SectionComboBox sections;
    private final JHexView hexView = new JHexView();
    private final INaviModule module;
    private JCheckBox virtualAddresses;
    private final IViewContainer container;
    private TypeInstanceAddressTableCellRenderer addressRenderer = new TypeInstanceAddressTableCellRenderer();
    private final IViewContainerListener internalViewContainerListener = new InternalViewContainerListener();
    private final TypeInstanceTableDatamodel typeDataModel;
    private final CodeDisplay typeDisplay;

    public DataSectionComponent(INaviModule module, IViewContainer container) {
        super(new BorderLayout(5, 5));
        this.module = Preconditions.checkNotNull(module, "Error: module argument can not be null");
        this.container = Preconditions.checkNotNull(container, "Error: type argument can not be null");
        this.container.addListener(this.internalViewContainerListener);
        this.hexView.setDefinitionStatus(JHexView.DefinitionStatus.DEFINED);
        this.hexView.setEnabled(true);
        this.hexView.setMenuCreator(new TypeInstanceMenu());
        this.typeDataModel = new TypeInstanceTableDatamodel();
        this.typeDisplay = new CodeDisplay(this.typeDataModel);
        this.typeDataModel.registerCodeDisplayToUpdate(this.typeDisplay);
        this.typeDisplay.addMouseListener(new TypeInstanceTableMouseListener());
        this.typeDisplay.addCaretChangedListener(new InstancesTableSelectionListener());
        this.add((Component)this.typeDisplay, "Center");
        JPanel panel = this.createOptionsPanel();
        this.add((Component)panel, "North");
        this.add((Component)this.hexView, "West");
        this.addressRenderer = new TypeInstanceAddressTableCellRenderer();
    }

    private static void initializeHighlighting(JHexView hexView, boolean useVirtualAddresses, Collection<TypeInstance> instances) {
        hexView.uncolorizeAll(5);
        for (TypeInstance instance : instances) {
            hexView.colorize(5, useVirtualAddresses ? instance.getAddress().getVirtualAddress() : instance.getAddress().getOffset(), instance.getBaseType().getByteSize(), Color.BLACK, Color.YELLOW);
        }
    }

    private final JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new FlowLayout(0));
        optionsPanel.setBorder(new TitledBorder("Options"));
        optionsPanel.add(this.createVirtualAddressCheckBox());
        optionsPanel.add(this.createSectionSelectionPanel());
        return optionsPanel;
    }

    private final JPanel createSectionSelectionPanel() {
        JPanel section_panel = new JPanel();
        JLabel lblSection = new JLabel("Section:");
        section_panel.add(lblSection);
        this.sections = new SectionComboBox();
        section_panel.add(this.sections);
        this.sections.addActionListener(new SectionSelectedListener());
        return section_panel;
    }

    private final JCheckBox createVirtualAddressCheckBox() {
        this.virtualAddresses = new JCheckBox("Show Virtual Addresses");
        this.virtualAddresses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (DataSectionComponent.this.virtualAddresses.isSelected()) {
                    DataSectionComponent.this.hexView.setBaseAddress(DataSectionComponent.this.currentSection.getStartAddress().toLong());
                    DataSectionComponent.this.addressRenderer.showVirtualAddress(true);
                } else {
                    DataSectionComponent.this.hexView.setBaseAddress(0L);
                    DataSectionComponent.this.addressRenderer.showVirtualAddress(false);
                }
                DataSectionComponent.initializeHighlighting(DataSectionComponent.this.hexView, DataSectionComponent.this.virtualAddresses.isSelected(), DataSectionComponent.this.module.getContent().getTypeInstanceContainer().getTypeInstances(DataSectionComponent.this.currentSection));
            }
        });
        return this.virtualAddresses;
    }

    private void highlightType(int row) {
        TypeInstance instance = this.typeDataModel.getTypeAtRow(row);
        this.hexView.uncolorizeAll(4);
        this.hexView.colorize(4, instance.getAddress().getOffset() + this.hexView.getBaseAddress(), instance.getBaseType().getByteSize(), Color.GREEN, Color.BLACK);
        this.hexView.gotoOffset(instance.getAddress().getOffset() + this.hexView.getBaseAddress());
    }

    private void moduleLoaded() {
        List<Section> sectionList = this.module.getContent().getSections().getSections();
        if (sectionList.isEmpty()) {
            return;
        }
        this.currentSection = sectionList.get(0);
        this.hexViewData = new HexViewDataAdapter(this.currentSection);
        this.hexView.setData(this.hexViewData);
        Collection<TypeInstance> instances = this.module.getContent().getTypeInstanceContainer().getTypeInstances(this.currentSection);
        DataSectionComponent.initializeHighlighting(this.hexView, this.virtualAddresses.isSelected(), instances);
        this.sections.setSections(sectionList);
        this.typeDataModel.setTypeInstanceContainer(this.module.getContent().getTypeInstanceContainer());
        this.typeDataModel.setSection(this.currentSection);
    }

    private void sectionChanged(Section section) {
        this.currentSection = section;
        this.hexViewData.setActiveSection(section);
        this.typeDataModel.setSection(section);
        DataSectionComponent.initializeHighlighting(this.hexView, this.virtualAddresses.isSelected(), this.module.getContent().getTypeInstanceContainer().getTypeInstances(section));
    }

    public JHexView getHexView() {
        return this.hexView;
    }

    public void scrollToInstance(TypeInstance instance) {
    }

    public void scrollToSectionAddress(Section section, long address) {
        this.sections.setSelectedItem(section);
        this.hexView.gotoOffset(address - section.getStartAddress().toLong());
    }

    private class TypeInstanceTableMouseListener
    extends MouseAdapter {
        private TypeInstanceTableMouseListener() {
        }

        private void handleClick(MouseEvent event) {
            int row = DataSectionComponent.this.typeDisplay.rowAtPoint(event.getPoint());
            if (event.isPopupTrigger()) {
                this.showPopupMenu(row, event);
            }
        }

        private void showPopupMenu(int rowIndex, MouseEvent event) {
            JPopupMenu popupMenu = new JPopupMenu();
            JFrame owner = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, DataSectionComponent.this);
            TypeInstanceContainer instanceContainer = DataSectionComponent.this.module.getContent().getTypeInstanceContainer();
            TypeManager typeManager = DataSectionComponent.this.module.getTypeManager();
            popupMenu.add(new CreateTypeInstanceAction(owner, instanceContainer, typeManager, DataSectionComponent.this.currentSection));
            if (rowIndex != -1) {
                TypeInstance existingInstance = DataSectionComponent.this.typeDataModel.getTypeAtRow(rowIndex);
                popupMenu.add(new EditTypeInstanceAction(owner, typeManager, existingInstance, instanceContainer));
                popupMenu.add(new DeleteTypeInstanceAction(owner, existingInstance, instanceContainer));
            }
            popupMenu.show(event.getComponent(), event.getX(), event.getY());
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2 && event.getButton() == 1 && DataSectionComponent.this.typeDisplay.columnAtPoint(event.getPoint()) == 3) {
                int row = DataSectionComponent.this.typeDisplay.rowAtPoint(event.getPoint());
                int line = DataSectionComponent.this.typeDisplay.lineAtPoint(event.getPoint());
                TypeInstanceReference reference = DataSectionComponent.this.typeDataModel.getTypeInstanceReference(row, line);
                if (reference == null) {
                    return;
                }
                JFrame owner = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, DataSectionComponent.this);
                Action actionProxy = CActionProxy.proxy(new OpenInLastWindowAndZoomToAddressAction(owner, DataSectionComponent.this.container, new INaviView[]{reference.getView()}, reference));
                actionProxy.actionPerformed(null);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.handleClick(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.handleClick(event);
        }
    }

    private class TypeInstanceMenu
    implements IMenuCreator {
        private TypeInstanceMenu() {
        }

        @Override
        public JPopupMenu createMenu(long offset) {
            JPopupMenu popupMenu = new JPopupMenu();
            TypeInstanceContainer instanceContainer = DataSectionComponent.this.module.getContent().getTypeInstanceContainer();
            TypeInstance existingInstance = instanceContainer.getTypeInstance(new TypeInstanceAddress(DataSectionComponent.this.currentSection.getStartAddress(), offset));
            if (existingInstance != null) {
                popupMenu.add(new EditTypeInstanceAction((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, DataSectionComponent.this), DataSectionComponent.this.module.getTypeManager(), existingInstance, instanceContainer));
            } else {
                popupMenu.add(new CreateTypeInstanceAction((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, DataSectionComponent.this), instanceContainer, DataSectionComponent.this.module.getTypeManager(), DataSectionComponent.this.currentSection, offset));
            }
            popupMenu.addSeparator();
            popupMenu.add(HexViewOptionsMenu.createHexViewOptionsMenu(DataSectionComponent.this.hexView));
            return popupMenu;
        }
    }

    private class SectionSelectedListener
    implements ActionListener {
        private SectionSelectedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SectionComboBox comboBox = (SectionComboBox)e2.getSource();
            Section section = (Section)comboBox.getSelectedItem();
            DataSectionComponent.this.sectionChanged(section);
        }
    }

    private class InternalViewContainerListener
    implements IViewContainerListener {
        private InternalViewContainerListener() {
        }

        @Override
        public void addedView(IViewContainer container, INaviView view) {
        }

        @Override
        public void closedContainer(IViewContainer container, List<INaviView> views) {
        }

        @Override
        public void deletedView(IViewContainer container, INaviView view) {
        }

        @Override
        public void loaded(IViewContainer container) {
            if (container.getModules().contains(DataSectionComponent.this.module)) {
                DataSectionComponent.this.moduleLoaded();
            }
        }
    }

    private class InstancesTableSelectionListener
    implements CodeDisplayEventListener {
        private InstancesTableSelectionListener() {
        }

        @Override
        public void caretChanged(CodeDisplayCoordinate caret) {
            DataSectionComponent.this.highlightType(caret.getRow());
        }
    }

    private class HexViewDataAdapter
    implements IDataProvider {
        private final ListenerProvider<IDataChangedListener> listeners = new ListenerProvider();
        private Section activeSection;

        public HexViewDataAdapter(Section currentSection) {
            this.activeSection = currentSection;
        }

        @Override
        public void addListener(IDataChangedListener hexView) {
            this.listeners.addListener(hexView);
        }

        @Override
        public byte[] getData() {
            return this.activeSection.getData();
        }

        @Override
        public byte[] getData(long offset, int length) {
            return Arrays.copyOfRange(this.getData(), (int)(offset - DataSectionComponent.this.hexView.getBaseAddress()), (int)(offset - DataSectionComponent.this.hexView.getBaseAddress() + (long)length));
        }

        @Override
        public int getDataLength() {
            return this.activeSection.getRawSize();
        }

        @Override
        public boolean hasData(long start, int length) {
            return start - DataSectionComponent.this.hexView.getBaseAddress() + (long)length <= (long)this.getDataLength();
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public boolean keepTrying() {
            return true;
        }

        @Override
        public void removeListener(IDataChangedListener listener) {
            this.listeners.removeListener(listener);
        }

        public void setActiveSection(Section section) {
            this.activeSection = section;
            for (IDataChangedListener listener : this.listeners) {
                listener.dataChanged();
            }
        }

        @Override
        public void setData(long offset, byte[] data) {
        }
    }
}

