/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component;

import com.google.common.base.Strings;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeHelpers;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.zylib.gui.CodeDisplay.FormattedCharacterBuffer;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.Color;
import java.awt.Font;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class BaseTypeTableCellRenderer {
    private static final int THRESHOLD = 30;
    private final boolean renderInstanceData;

    public BaseTypeTableCellRenderer(boolean renderInstanceData) {
        this.renderInstanceData = renderInstanceData;
    }

    private static void appendString(StyledDocument document, String string2, Style style) throws BadLocationException {
        document.insertString(document.getLength(), string2, style);
    }

    private static Style createDataStyle(StyledDocument document) {
        Style declStyle = document.addStyle("DATA_STYLE", null);
        StyleConstants.setBackground(declStyle, Color.WHITE);
        StyleConstants.setForeground(declStyle, Color.BLUE);
        StyleConstants.setFontFamily(declStyle, GuiHelper.getMonospaceFont());
        StyleConstants.setFontSize(declStyle, 11);
        return declStyle;
    }

    private static Style createDeclarationStyle(StyledDocument document) {
        Style declStyle = document.addStyle("DECL_STYLE", null);
        StyleConstants.setBackground(declStyle, Color.WHITE);
        StyleConstants.setForeground(declStyle, Color.BLACK);
        StyleConstants.setFontFamily(declStyle, GuiHelper.getMonospaceFont());
        StyleConstants.setFontSize(declStyle, 11);
        return declStyle;
    }

    private static void generateDocument(TypeInstance instance, boolean renderData, StyledDocument document) {
        switch (instance.getBaseType().getCategory()) {
            case ARRAY: {
                BaseTypeTableCellRenderer.renderArray(instance, document, renderData);
                break;
            }
            case ATOMIC: {
                BaseTypeTableCellRenderer.renderAtomic(instance, document, renderData);
                break;
            }
            case POINTER: {
                BaseTypeTableCellRenderer.renderPointer(instance, document);
                break;
            }
            case STRUCT: {
                BaseTypeTableCellRenderer.renderStruct(instance, document, renderData);
                break;
            }
        }
    }

    private static int getRenderDataLength(BaseType baseType) {
        int size = baseType.getByteSize();
        return size > 30 ? 30 : size;
    }

    private static void renderArray(TypeInstance instance, StyledDocument document, boolean renderData) {
        Style arrayStyle = BaseTypeTableCellRenderer.createDeclarationStyle(document);
        try {
            document.remove(0, document.getLength());
            BaseType baseType = instance.getBaseType();
            BaseTypeTableCellRenderer.appendString(document, baseType.getName(), arrayStyle);
            if (renderData) {
                BaseTypeTableCellRenderer.appendString(document, BaseTypeTableCellRenderer.renderInstanceData(baseType, instance.getAddress().getOffset(), instance.getSection()), BaseTypeTableCellRenderer.createDataStyle(document));
            }
        }
        catch (BadLocationException exception) {
            CUtilityFunctions.logException(exception);
        }
    }

    private static void renderAtomic(TypeInstance instance, StyledDocument document, boolean renderData) {
        Style atomicStyle = BaseTypeTableCellRenderer.createDeclarationStyle(document);
        try {
            document.remove(0, document.getLength());
            BaseType baseType = instance.getBaseType();
            BaseTypeTableCellRenderer.appendString(document, baseType.getName(), atomicStyle);
            if (renderData) {
                BaseTypeTableCellRenderer.appendString(document, BaseTypeTableCellRenderer.renderInstanceData(baseType, instance.getAddress().getOffset(), instance.getSection()), BaseTypeTableCellRenderer.createDataStyle(document));
            }
        }
        catch (BadLocationException exception) {
            CUtilityFunctions.logException(exception);
        }
    }

    private static String renderInstanceData(BaseType baseType, long offset, Section section) {
        int size = BaseTypeTableCellRenderer.getRenderDataLength(baseType);
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        byte[] data = section.getData();
        int strideLength = baseType.getCategory() == BaseTypeCategory.ARRAY ? BaseTypeHelpers.getArrayElementByteSize(baseType) : size;
        for (long currentOffset = offset; currentOffset < offset + (long)size; ++currentOffset) {
            if (currentOffset - offset != 0L && (currentOffset - offset) % (long)strideLength == 0L) {
                builder.append(", ");
            }
            builder.append(String.format("%02X", data[(int)currentOffset]));
        }
        if (size == 30) {
            builder.append("...");
        }
        builder.append(']');
        return builder.toString();
    }

    private static void renderPointer(TypeInstance instance, StyledDocument document) {
        Style pointerStyle = BaseTypeTableCellRenderer.createDeclarationStyle(document);
        try {
            document.remove(0, document.getLength());
            BaseTypeTableCellRenderer.appendString(document, instance.getBaseType().getName(), pointerStyle);
        }
        catch (BadLocationException exception) {
            CUtilityFunctions.logException(exception);
        }
    }

    private static void renderStruct(TypeInstance instance, StyledDocument document, boolean renderData) {
        Style structNameStyle = BaseTypeTableCellRenderer.createDeclarationStyle(document);
        Style structMemberStyle = document.addStyle("STRUCTMEMBERSTYLE", structNameStyle);
        StyleConstants.setForeground(structMemberStyle, Color.GRAY);
        Style structContentStyle = document.addStyle("STRUCTCONTENTSTYLE", structNameStyle);
        StyleConstants.setForeground(structContentStyle, Color.BLUE);
        StyleConstants.setAlignment(structNameStyle, 2);
        BaseType baseType = instance.getBaseType();
        int maxMemberLength = 0;
        for (Object member : baseType) {
            if (((TypeMember)member).getBaseType().getName().length() <= maxMemberLength) continue;
            maxMemberLength = ((TypeMember)member).getBaseType().getName().length();
        }
        int maxNameLength = 0;
        for (TypeMember member : baseType) {
            if (member.getName().length() <= maxNameLength) continue;
            maxNameLength = member.getName().length();
        }
        try {
            Object member;
            document.remove(0, document.getLength());
            member = baseType.getName();
            BaseTypeTableCellRenderer.appendString(document, new StringBuilder(10 + String.valueOf(member).length()).append("struct ").append((String)member).append(" {\n").toString(), structNameStyle);
            long memberOffset = 0L;
            for (TypeMember member2 : baseType) {
                String string2 = String.valueOf(member2.getBaseType().getName());
                BaseTypeTableCellRenderer.appendString(document, string2.length() != 0 ? "  ".concat(string2) : new String("  "), structNameStyle);
                String separator = Strings.repeat(" ", maxMemberLength - member2.getBaseType().getName().length() + 1);
                String string3 = String.valueOf(separator);
                String string4 = String.valueOf(member2.getName());
                BaseTypeTableCellRenderer.appendString(document, string4.length() != 0 ? string3.concat(string4) : new String(string3), structMemberStyle);
                BaseTypeTableCellRenderer.appendString(document, ";", structMemberStyle);
                if (renderData) {
                    String dataSeperator = Strings.repeat(".", maxNameLength - member2.getName().length() + 1);
                    BaseTypeTableCellRenderer.appendString(document, dataSeperator, structNameStyle);
                    BaseTypeTableCellRenderer.appendString(document, BaseTypeTableCellRenderer.renderInstanceData(member2.getBaseType(), instance.getAddress().getOffset() + memberOffset, instance.getSection()), BaseTypeTableCellRenderer.createDataStyle(document));
                    memberOffset += (long)member2.getBaseType().getByteSize();
                }
                BaseTypeTableCellRenderer.appendString(document, "\n", structMemberStyle);
            }
            BaseTypeTableCellRenderer.appendString(document, "};", structNameStyle);
        }
        catch (BadLocationException exception) {
            CUtilityFunctions.logException(exception);
        }
    }

    public static String renderText(TypeInstance instance) {
        DefaultStyledDocument document = new DefaultStyledDocument();
        BaseTypeTableCellRenderer.generateDocument(instance, false, document);
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException exception) {
            CUtilityFunctions.logException(exception);
            return "";
        }
    }

    protected void generateDocument(StyledDocument document, Object value) {
        BaseTypeTableCellRenderer.generateDocument((TypeInstance)value, this.renderInstanceData, document);
    }

    public static FormattedCharacterBuffer convertDocumentToFormattedCharacterBuffer(StyledDocument document, Font font, int desiredWidth) {
        int width = desiredWidth;
        int height = 0;
        String text2 = "";
        try {
            text2 = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        String[] chunks = text2.split("\n");
        height = chunks.length;
        for (String line : chunks) {
            width = Math.max(width, line.length() + 1);
        }
        FormattedCharacterBuffer result = new FormattedCharacterBuffer(height, width);
        int lineindex = 0;
        int columnindex = 0;
        for (int index = 0; index < document.getLength(); ++index) {
            if (text2.charAt(index) != '\n') {
                AttributeSet attributes = document.getCharacterElement(index).getAttributes();
                Color foreground = document.getForeground(attributes);
                Color background = document.getBackground(attributes);
                result.setAt(lineindex, ++columnindex, text2.charAt(index), font, foreground, background);
                continue;
            }
            columnindex = 0;
            ++lineindex;
        }
        return result;
    }

    public static FormattedCharacterBuffer renderType(TypeInstance instance, Font font, int desiredWidth, boolean renderData) {
        DefaultStyledDocument document = new DefaultStyledDocument();
        BaseTypeTableCellRenderer.generateDocument(instance, renderData, document);
        return BaseTypeTableCellRenderer.convertDocumentToFormattedCharacterBuffer(document, font, desiredWidth);
    }

    public static FormattedCharacterBuffer renderTypeLine(TypeInstance instance, Font font, int desiredWidth, boolean renderData, int line) {
        DefaultStyledDocument document = new DefaultStyledDocument();
        BaseTypeTableCellRenderer.generateDocument(instance, renderData, document);
        return BaseTypeTableCellRenderer.convertDocumentToFormattedCharacterBuffer(document, font, desiredWidth);
    }
}

