/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.plugins.IMainWindowMenuPlugin;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.CActionExit;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionAbout;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionContextHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionInitialCallgraphSettings;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionInitialFlowgraphSettings;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionOpenLogConsole;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionOpenScriptingDialog;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionReportBug;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CActionShowSettingsDialog;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CAddDatabaseAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CCheckForUpdatesAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CPluginManagementAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CPluginsReloadAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CStartTutorialAction;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.api2.IPluginInterface;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public abstract class CAbstractMenuBuilder {
    private final JTree m_projectTree;
    private JPopupMenu m_popupMenu;
    private JMenuBar m_mainMenu;

    protected CAbstractMenuBuilder(JTree projectTree) {
        this.m_projectTree = Preconditions.checkNotNull(projectTree, "IE01938: Project tree argument can not be null");
    }

    private JMenu createAboutMenu() {
        JMenu menu = new JMenu("Help");
        JFrame parent = this.getParent();
        menu.setMnemonic('H');
        menu.add(new JMenuItem(new CActionHelp(parent)));
        menu.add(new JMenuItem(new CActionContextHelp(parent)));
        menu.addSeparator();
        menu.add(new JMenuItem(new CStartTutorialAction(parent)));
        menu.addSeparator();
        menu.add(new JMenuItem(new CActionReportBug(parent)));
        menu.add(new JMenuItem(new CCheckForUpdatesAction(parent)));
        menu.add(new JMenuItem(new CActionAbout(parent)));
        return menu;
    }

    private JMenu createBinNaviMenu() {
        JMenu menu = new JMenu("BinNavi");
        menu.setMnemonic('B');
        menu.add(CActionProxy.proxy(new CAddDatabaseAction(this.m_projectTree)));
        menu.addSeparator();
        menu.add(CActionProxy.proxy(new CActionExit(this.getParent())));
        return menu;
    }

    private void createMenus() {
        this.m_mainMenu = new JMenuBar();
        this.m_mainMenu.add(this.createBinNaviMenu());
        JMenu menu = this.getMenu();
        if (menu != null) {
            this.createMenu(menu);
            this.m_mainMenu.add(menu);
        }
        this.m_mainMenu.add(this.createPluginsMenu());
        this.m_mainMenu.add(this.createSettingsMenu());
        this.m_mainMenu.add(this.createAboutMenu());
        this.m_popupMenu = new JPopupMenu();
        this.createMenu(this.m_popupMenu);
    }

    private JMenu createPluginsMenu() {
        ArrayList<IMainWindowMenuPlugin> plugins = new ArrayList<IMainWindowMenuPlugin>();
        for (IPlugin<IPluginInterface> plugin : PluginInterface.instance().getPluginRegistry()) {
            if (!(plugin instanceof IMainWindowMenuPlugin)) continue;
            plugins.add((IMainWindowMenuPlugin)plugin);
        }
        JMenu menu = new JMenu("Plugins");
        menu.setMnemonic('U');
        menu.add(CActionProxy.proxy(new CActionOpenScriptingDialog(this.getParent())));
        menu.add(CActionProxy.proxy(new CActionOpenLogConsole()));
        menu.addSeparator();
        menu.add(CActionProxy.proxy(new CPluginManagementAction(this.getParent())));
        menu.add(CActionProxy.proxy(new CPluginsReloadAction()));
        menu.addSeparator();
        for (IMainWindowMenuPlugin plugin : plugins) {
            try {
                List<JMenuItem> menus = plugin.extendPluginMenu();
                for (JMenuItem m2 : menus) {
                    menu.add(m2);
                }
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
                String innerMessage = "E00092: Plugin caused an unexpected exception";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The plugin %s caused an unexpected exception.", plugin.getName()), new String[]{"The plugin contains a bug."}, new String[]{"The plugin probably behaves erroneously from this point on but it remains active"});
                NaviErrorDialog.show(this.getParent(), "E00092: Plugin caused an unexpected exception", innerDescription, exception);
            }
        }
        return menu;
    }

    private JMenu createSettingsMenu() {
        JMenu menu = new JMenu("Settings");
        menu.setMnemonic('S');
        menu.add(new CActionShowSettingsDialog(this.getParent()));
        menu.add(new JSeparator());
        menu.add(new CActionInitialCallgraphSettings(this.getParent()));
        menu.add(new CActionInitialFlowgraphSettings(this.getParent()));
        return menu;
    }

    protected abstract void createMenu(JComponent var1);

    protected void dispose() {
    }

    protected abstract JMenu getMenu();

    protected JFrame getParent() {
        return (JFrame)SwingUtilities.getWindowAncestor(this.m_projectTree);
    }

    protected JTree getProjectTree() {
        return this.m_projectTree;
    }

    public JMenuBar getMainMenu() {
        this.createMenus();
        return this.m_mainMenu;
    }

    public JPopupMenu getPopupMenu() {
        this.createMenus();
        return this.m_popupMenu;
    }
}

