/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CAddressSpaceFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CModuleFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.CProjectModulesModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CLoadedRenderer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.CModuleNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.Component.Help.CModulesTableHelp;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public final class CProjectModulesTable
extends CAbstractTreeTable<INaviModule> {
    private static final long serialVersionUID = 463220162389426879L;
    private final IDatabase m_database;
    private final INaviAddressSpace m_addressSpace;

    public CProjectModulesTable(JTree projectTree, IDatabase database, INaviAddressSpace addressSpace) {
        super(projectTree, new CProjectModulesModel(addressSpace), new CModulesTableHelp());
        this.m_database = Preconditions.checkNotNull(database, "IE02868: database argument can not be null");
        this.m_addressSpace = Preconditions.checkNotNull(addressSpace, "IE02869: addressSpace argument can not be null");
        this.setDefaultRenderer(Object.class, new ModuleLoadedRenderer());
        InputMap windowImap = this.getInputMap(0);
        windowImap.put(HotKeys.LOAD_HK.getKeyStroke(), "LOAD");
        this.getActionMap().put("LOAD", CActionProxy.proxy(new LoadModuleAction()));
    }

    private INaviModule[] getModules(int[] sortSelectedRows) {
        INaviModule[] modules = new INaviModule[sortSelectedRows.length];
        for (int i2 = 0; i2 < modules.length; ++i2) {
            modules[i2] = this.m_addressSpace.getContent().getModules().get(sortSelectedRows[i2]);
        }
        return modules;
    }

    private INaviModule[] getSelectedModules(int sortedRow) {
        int[] sortSelectedRows = this.getSortSelectedRows();
        if (Ints.asList(sortSelectedRows).indexOf(sortedRow) != -1) {
            return this.getModules(sortSelectedRows);
        }
        int viewRow = this.convertRowIndexToView(sortedRow);
        this.setRowSelectionInterval(viewRow, viewRow);
        return new INaviModule[]{this.m_addressSpace.getContent().getModules().get(sortedRow)};
    }

    private INaviModule[] getUnloadedModules(INaviModule[] modules) {
        ArrayList<INaviModule> unloadedModules = new ArrayList<INaviModule>();
        for (INaviModule module : modules) {
            if (!module.getConfiguration().getRawModule().isComplete() || !module.isInitialized() || module.isLoaded()) continue;
            unloadedModules.add(module);
        }
        return unloadedModules.toArray(new INaviModule[0]);
    }

    @Override
    protected void deleteRows() {
        CAddressSpaceFunctions.removeModules(this.getParentWindow(), this.m_addressSpace, this.getModules(this.getSortSelectedRows()));
    }

    @Override
    protected JPopupMenu getPopupMenu(int x2, int y2, int row) {
        CModuleNodeMenuBuilder menu = new CModuleNodeMenuBuilder(this.getProjectTree(), null, this.m_database, this.m_addressSpace, this.getSelectedModules(row), this);
        return menu.getPopupMenu();
    }

    @Override
    protected void handleDoubleClick(int row) {
    }

    private class ModuleLoadedRenderer
    extends CLoadedRenderer {
        private static final long serialVersionUID = -7356576005733389597L;

        private ModuleLoadedRenderer() {
        }

        @Override
        public boolean isLoaded(int row) {
            return CProjectModulesTable.this.getModules(new int[]{CProjectModulesTable.this.convertRowIndexToModel(row)})[0].isLoaded();
        }
    }

    private class LoadModuleAction
    extends AbstractAction {
        private static final long serialVersionUID = 6811696892700433916L;

        private LoadModuleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CModuleFunctions.loadModules(CProjectModulesTable.this.getProjectTree(), CProjectModulesTable.this.getUnloadedModules(CProjectModulesTable.this.getModules(CProjectModulesTable.this.getSortSelectedRows())));
        }
    }
}

