/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.IDebuggerContainer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.IDebuggerContainerListener;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.IProjectListener;
import java.util.ArrayList;
import java.util.List;

public final class CProjectDebuggerContainer
implements IDebuggerContainer {
    private final INaviProject m_project;
    private final List<IProjectListener> m_wrappers = new ArrayList<IProjectListener>();

    public CProjectDebuggerContainer(INaviProject project) {
        Preconditions.checkNotNull(project, "IE01954: Project argument can not be null");
        this.m_project = project;
    }

    @Override
    public void addListener(IDebuggerContainerListener listener) {
        ListenerWrapper wrapper = new ListenerWrapper(listener);
        this.m_project.addListener(wrapper);
        this.m_wrappers.add(wrapper);
    }

    public void dispose() {
        for (IProjectListener listener : this.m_wrappers) {
            this.m_project.removeListener(listener);
        }
    }

    @Override
    public List<DebuggerTemplate> getDebuggers() {
        return this.m_project.getConfiguration().getDebuggers();
    }

    private class ListenerWrapper
    extends CProjectListenerAdapter {
        private final IDebuggerContainerListener m_listener;

        private ListenerWrapper(IDebuggerContainerListener listener) {
            this.m_listener = listener;
        }

        @Override
        public void addedDebugger(INaviProject project, DebuggerTemplate debugger) {
            this.m_listener.addedDebugger(CProjectDebuggerContainer.this, debugger);
        }

        @Override
        public void removedDebugger(INaviProject project, DebuggerTemplate debugger) {
            this.m_listener.removedDebugger(CProjectDebuggerContainer.this, debugger);
        }
    }
}

