/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CLoadAddressSpaceAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.CAddressSpaceNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.CAddressSpaceNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.CModuleNode;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceConfigurationListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceContent;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceContentListener;
import com.google.security.zynamics.binnavi.disassembly.CProjectContainer;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public final class CAddressSpaceNode
extends CProjectTreeNode<INaviAddressSpace> {
    private static final long serialVersionUID = -927976512288945336L;
    private static final ImageIcon ICON_ADDRESSSPACE = new ImageIcon(CMain.class.getResource("data/projecttreeicons/addressspace2.png"));
    private static final ImageIcon ICON_ADDRESSSPACE_GRAY = new ImageIcon(CMain.class.getResource("data/projecttreeicons/addressspace_gray.png"));
    private final IDatabase m_database;
    private final INaviProject m_project;
    private final INaviAddressSpace m_addressSpace;
    private final InternalAddressSpaceListener m_addrSpaceListener = new InternalAddressSpaceListener();
    private final InternalAddressSpaceConfigurationListener m_addrSpaceConfigurationListener = new InternalAddressSpaceConfigurationListener();
    private final InternalAddressSpaceContentListener m_addrSpaceContentListener = new InternalAddressSpaceContentListener();

    public CAddressSpaceNode(final JTree projectTree, DefaultMutableTreeNode parentNode, final IDatabase database, final INaviProject project, final INaviAddressSpace addressSpace, IViewContainer container) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CAddressSpaceNodeComponent(projectTree, database, project, addressSpace);
            }
        }, new CAddressSpaceNodeMenuBuilder(projectTree, parentNode, null, database, project, new INaviAddressSpace[]{addressSpace}, container), addressSpace);
        this.m_project = Preconditions.checkNotNull(project, "IE01941: Project can't be null");
        this.m_addressSpace = Preconditions.checkNotNull(addressSpace, "IE01942: Address space can't be null");
        this.m_database = Preconditions.checkNotNull(database, "IE02344: Database argument can not be null");
        this.createChildren();
        this.m_addressSpace.addListener(this.m_addrSpaceListener);
        this.m_addressSpace.getConfiguration().addListener(this.m_addrSpaceConfigurationListener);
    }

    @Override
    protected void createChildren() {
        if (this.m_addressSpace.isLoaded()) {
            this.m_addressSpace.getContent().addListener(this.m_addrSpaceContentListener);
            for (INaviModule module : this.m_addressSpace.getContent().getModules()) {
                this.add(new CModuleNode(this.getProjectTree(), this, this.m_database, this.m_addressSpace, module, new CProjectContainer(this.m_database, this.m_project, this.m_addressSpace)));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_addressSpace.isLoaded()) {
            this.m_addressSpace.getContent().removeListener(this.m_addrSpaceContentListener);
        }
        this.m_addressSpace.removeListener(this.m_addrSpaceListener);
        this.m_addressSpace.getConfiguration().removeListener(this.m_addrSpaceConfigurationListener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
        if (!this.m_addressSpace.isLoaded()) {
            Action action = CActionProxy.proxy(new CLoadAddressSpaceAction(this.getProjectTree(), new INaviAddressSpace[]{this.m_addressSpace}));
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    @Override
    public Icon getIcon() {
        return this.m_addressSpace.isLoaded() ? ICON_ADDRESSSPACE : ICON_ADDRESSSPACE_GRAY;
    }

    @Override
    public String toString() {
        String string2 = this.m_addressSpace.getConfiguration().getName();
        String string3 = String.valueOf(this.m_addressSpace.isLoaded() ? Integer.valueOf(this.m_addressSpace.getContent().getModules().size()) : "?");
        return new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" (").append(string3).append(")").toString();
    }

    private class InternalAddressSpaceListener
    extends CAddressSpaceListenerAdapter {
        private InternalAddressSpaceListener() {
        }

        @Override
        public void closed(INaviAddressSpace addressSpace, CAddressSpaceContent content) {
            content.removeListener(CAddressSpaceNode.this.m_addrSpaceContentListener);
        }

        @Override
        public void loaded(INaviAddressSpace addressSpace) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CAddressSpaceNode.this.createChildren();
                    CAddressSpaceNode.this.getTreeModel().nodeStructureChanged(CAddressSpaceNode.this);
                }
            }.invokeAndWait();
        }
    }

    private class InternalAddressSpaceContentListener
    implements IAddressSpaceContentListener {
        private InternalAddressSpaceContentListener() {
        }

        @Override
        public void addedModule(final INaviAddressSpace addressSpace, final INaviModule module) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CAddressSpaceNode.this.add(new CModuleNode(CAddressSpaceNode.this.getProjectTree(), CAddressSpaceNode.this, CAddressSpaceNode.this.m_database, addressSpace, module, new CProjectContainer(CAddressSpaceNode.this.m_database, CAddressSpaceNode.this.m_project, addressSpace)));
                    CAddressSpaceNode.this.getTreeModel().nodeStructureChanged(CAddressSpaceNode.this);
                }
            }.invokeAndWait();
        }

        @Override
        public void changedImageBase(INaviAddressSpace addressSpace, INaviModule module, IAddress address) {
        }

        @Override
        public void removedModule(INaviAddressSpace addressSpace, final INaviModule module) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    for (int i2 = 0; i2 < CAddressSpaceNode.this.getChildCount(); ++i2) {
                        CModuleNode node = (CModuleNode)CAddressSpaceNode.this.getChildAt(i2);
                        if (node.getObject() != module) continue;
                        node.dispose();
                        CAddressSpaceNode.this.remove(node);
                        break;
                    }
                    CAddressSpaceNode.this.getTreeModel().nodeStructureChanged(CAddressSpaceNode.this);
                }
            }.invokeAndWait();
        }
    }

    private class InternalAddressSpaceConfigurationListener
    extends CAddressSpaceConfigurationListenerAdapter {
        private InternalAddressSpaceConfigurationListener() {
        }

        @Override
        public void changedName(INaviAddressSpace addressSpace, String name) {
            CAddressSpaceNode.this.getTreeModel().nodeChanged(CAddressSpaceNode.this);
        }
    }
}

