/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.DragAndDrop;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CAddressSpaceFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.DragAndDrop.CAbstractDropHandler;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.DragAndDrop.CModuleTransferable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.CAddressSpaceNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.CModuleNode;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.zylib.gui.dndtree.DNDTree;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class CModulesToAddressSpaceHandler
extends CAbstractDropHandler {
    private final JFrame m_parent;

    public CModulesToAddressSpaceHandler(JFrame parent) {
        super(CModuleTransferable.MODULE_FLAVOR);
        Preconditions.checkNotNull(parent, "IE01928: Parent argument can not be null");
        this.m_parent = parent;
    }

    @Override
    public boolean canHandle(DefaultMutableTreeNode parentNode, DefaultMutableTreeNode draggedNode) {
        if (parentNode instanceof CAddressSpaceNode && draggedNode instanceof CModuleNode) {
            CModuleNode draggedModule = (CModuleNode)draggedNode;
            CAddressSpaceNode targetAddressSpace = (CAddressSpaceNode)parentNode;
            return ((INaviAddressSpace)targetAddressSpace.getObject()).isLoaded() && !((INaviAddressSpace)targetAddressSpace.getObject()).getContent().getModules().contains(draggedModule.getObject()) && ((INaviAddressSpace)targetAddressSpace.getObject()).inSameDatabase((IDatabaseObject)draggedModule.getObject());
        }
        return false;
    }

    @Override
    public boolean canHandle(DefaultMutableTreeNode parentNode, Object data) {
        if (parentNode instanceof CAddressSpaceNode) {
            List modules = (List)data;
            if (modules.isEmpty()) {
                return false;
            }
            return ((CModule)modules.get(0)).inSameDatabase((IDatabaseObject)((CAddressSpaceNode)parentNode).getObject());
        }
        return false;
    }

    @Override
    public void drop(DefaultMutableTreeNode parentNode, Object data) {
        CAddressSpaceNode addressSpaceNode = (CAddressSpaceNode)parentNode;
        INaviAddressSpace addressSpace = (INaviAddressSpace)addressSpaceNode.getObject();
        List modules = (List)data;
        for (CModule module : modules) {
            CAddressSpaceFunctions.addModule(this.m_parent, addressSpace, module);
        }
    }

    @Override
    public void drop(DNDTree target, DefaultMutableTreeNode parentNode, DefaultMutableTreeNode draggedNode) {
        CModuleNode draggedNodeNode = (CModuleNode)draggedNode;
        CAddressSpaceNode parentNodeNode = (CAddressSpaceNode)parentNode;
        CAddressSpaceFunctions.addModule(this.m_parent, (INaviAddressSpace)parentNodeNode.getObject(), (INaviModule)draggedNodeNode.getObject());
        target.setSelectionPath(new TreePath(parentNodeNode.getLastLeaf().getPath()));
        target.setSelectionPath(new TreePath(draggedNodeNode.getPath()));
    }
}

