/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.CDatabaseManager;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CAddDatabaseAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.CProjectTreeDragHandlerInitializer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.CProjectTreeModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.IProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Root.CRootNode;
import com.google.security.zynamics.binnavi.Help.CHelpFunctions;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import com.google.security.zynamics.binnavi.Help.IHelpProvider;
import com.google.security.zynamics.zylib.gui.dndtree.DNDTree;
import com.google.security.zynamics.zylib.gui.jtree.IconNodeRenderer;
import com.google.security.zynamics.zylib.gui.jtree.TreeHelpers;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class CProjectTree
extends DNDTree
implements IHelpProvider {
    private static final long serialVersionUID = 1615290227300451827L;
    private final JPopupMenu m_popup = new JPopupMenu();
    private final CRootNode m_rootNode;
    private final CProjectTreeModel m_treeModel;

    public CProjectTree(JFrame parent, CDatabaseManager databaseManager) {
        Preconditions.checkNotNull(databaseManager, "IE01840: Database manager object can't be null");
        this.m_treeModel = new CProjectTreeModel(this);
        this.setModel(this.m_treeModel);
        CProjectTreeDragHandlerInitializer.initialize(parent, this, databaseManager);
        this.addMouseListener(new InternalMouseListener());
        this.setScrollsOnExpand(false);
        this.setRootVisible(false);
        this.m_rootNode = new CRootNode(this, databaseManager);
        this.m_treeModel.setRoot(this.m_rootNode);
        this.setCellRenderer(new IconNodeRenderer());
        this.m_popup.add(CActionProxy.proxy(new CAddDatabaseAction(this)));
    }

    private void handleDoubleClick(MouseEvent event) {
        IProjectTreeNode selectedNode = (IProjectTreeNode)TreeHelpers.getNodeAt(this, event.getX(), event.getY());
        if (selectedNode == null) {
            return;
        }
        selectedNode.doubleClicked();
    }

    private void showPopupMenu(MouseEvent event) {
        IProjectTreeNode selectedNode = (IProjectTreeNode)TreeHelpers.getNodeAt(this, event.getX(), event.getY());
        if (selectedNode == null) {
            this.m_popup.show(this, event.getX(), event.getY());
        } else {
            this.setSelectionPath(new TreePath(((DefaultMutableTreeNode)((Object)selectedNode)).getPath()));
            JPopupMenu menu = selectedNode.getPopupMenu();
            if (menu != null) {
                menu.show(this, event.getX(), event.getY());
            }
        }
    }

    @Override
    public IHelpInformation getHelpInformation() {
        return new IHelpInformation(){

            @Override
            public String getText() {
                return "The Project Tree gives a quick overview of the BinNavi databases you have configured and the data stored in the databases.";
            }

            @Override
            public URL getUrl() {
                return CHelpFunctions.urlify("main_window.htm");
            }
        };
    }

    @Override
    public CProjectTreeModel getModel() {
        return this.m_treeModel;
    }

    public CRootNode getRootNode() {
        return this.m_rootNode;
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2 && event.getButton() == 1) {
                CProjectTree.this.handleDoubleClick(event);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CProjectTree.this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CProjectTree.this.showPopupMenu(event);
            }
        }
    }
}

