/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CModuleFunctions;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTree;

public final class CLoadModuleAction
extends AbstractAction {
    private static final long serialVersionUID = -5178343179269965998L;
    private final JTree m_projectTree;
    private final INaviModule[] m_modules;

    public CLoadModuleAction(JTree projectTree, INaviModule[] modules) {
        super(CLoadModuleAction.generateActionString(modules));
        this.m_projectTree = Preconditions.checkNotNull(projectTree, "IE01901: Project tree argument can not be null");
        this.m_modules = (INaviModule[])Preconditions.checkNotNull(modules, "IE01902: Modules argument can't be null").clone();
        for (INaviModule module : modules) {
            Preconditions.checkNotNull(module, "IE01903: Modules list contains a null-element");
        }
        this.putValue("AcceleratorKey", HotKeys.LOAD_HK.getKeyStroke());
        this.putValue("MnemonicKey", "HK_MENU_LOAD_MODULE".charAt(0));
    }

    public static String generateActionString(INaviModule module) {
        if (module.isInitialized()) {
            return "Load Module";
        }
        return "Initialize & Load Module";
    }

    private static String generateActionString(INaviModule[] modules) {
        if (modules.length == 1) {
            INaviModule module = modules[0];
            return CLoadModuleAction.generateActionString(module);
        }
        boolean allLoad = true;
        boolean allInitialize = true;
        for (INaviModule module : modules) {
            if (module.isInitialized()) {
                allInitialize = false;
                continue;
            }
            allLoad = false;
        }
        if (allLoad) {
            return "Load Modules";
        }
        if (allInitialize) {
            return "Initialize & Load Modules";
        }
        return "Load / Initialize & Load Modules";
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CModuleFunctions.loadModules(this.m_projectTree, this.m_modules);
    }
}

