/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CAddressSpaceFunctions;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTree;

public final class CLoadAddressSpaceAction
extends AbstractAction {
    private static final long serialVersionUID = 8781428465526314731L;
    private final JTree m_tree;
    private final INaviAddressSpace[] m_spaces;

    public CLoadAddressSpaceAction(JTree tree, INaviAddressSpace[] spaces) {
        super("Load Address Space");
        this.m_tree = Preconditions.checkNotNull(tree, "IE01898: Tree argument can not be null");
        this.m_spaces = (INaviAddressSpace[])Preconditions.checkNotNull(spaces, "IE01899: Address spaces argument can't be null").clone();
        for (INaviAddressSpace addressSpace : spaces) {
            Preconditions.checkNotNull(addressSpace, "IE01900: Address spaces list contains a null-element");
        }
        this.putValue("AcceleratorKey", HotKeys.LOAD_HK.getKeyStroke());
        this.putValue("MnemonicKey", "HK_MENU_LOAD_ADDRESS_SPACE".charAt(0));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CAddressSpaceFunctions.loadAddressSpaces(this.m_tree, this.m_spaces);
    }
}

