/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNameListGenerators;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Window;

public final class CViewContainerFunctions {
    private CViewContainerFunctions() {
    }

    public static void deleteViews(Window parent, IViewContainer viewContainer, INaviView[] views) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to delete the following views?\n\n%s", CNameListGenerators.getNameList(views))) == 0) {
            for (INaviView view : views) {
                try {
                    viewContainer.deleteView(view);
                }
                catch (CouldntDeleteException exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = "E00148: Could not delete view";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be deleted.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view was not deleted and can still be used."});
                    NaviErrorDialog.show(parent, "E00148: Could not delete view", innerDescription, exception);
                }
            }
        }
    }
}

