/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.Progress.CDefaultProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import com.google.security.zynamics.zylib.types.trees.TreeNode;
import javax.swing.JFrame;

public final class CTagFunctions {
    private CTagFunctions() {
    }

    public static void addTag(final JFrame parent, final ITagManager tagManager, final ITreeNode<CTag> parentTag, final String name) {
        new Thread(){

            @Override
            public void run() {
                try {
                    CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, false);
                    operation.getProgressPanel().setMaximum(1);
                    String string2 = String.valueOf("Creating new tag: ");
                    String string3 = String.valueOf(name);
                    operation.getProgressPanel().setText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
                    tagManager.addTag(parentTag, name);
                    operation.getProgressPanel().next();
                    operation.stop();
                }
                catch (CouldntSaveDataException exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = "E00144: Could not create tag";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The new tag '%s' could not be created.", name), new String[]{"There was a problem with the database connection."}, new String[]{"The tag was not created."});
                    NaviErrorDialog.show(parent, "E00144: Could not create tag", innerDescription, exception);
                }
            }
        }.start();
    }

    public static void deleteTag(final JFrame parent, final ITagManager tagManager, final TreeNode<CTag> tag) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to delete the tag '%s' from the database?", tag.getObject().getName())) == 0) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, false);
                        operation.getProgressPanel().setMaximum(1);
                        String string2 = String.valueOf("Deleting tag: ");
                        String string3 = String.valueOf(((CTag)tag.getObject()).getName());
                        operation.getProgressPanel().setText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
                        tagManager.deleteTag(tag);
                        operation.getProgressPanel().next();
                        operation.stop();
                    }
                    catch (CouldntDeleteException e2) {
                        CUtilityFunctions.logException(e2);
                        String innerMessage = "E00145: Could not delete tag";
                        String innerDescription = CUtilityFunctions.createDescription(String.format("The tag '%s' could not be deleted.", ((CTag)tag.getObject()).getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag was not deleted and can still be used."});
                        NaviErrorDialog.show(parent, "E00145: Could not delete tag", innerDescription, e2);
                    }
                }
            }.start();
        }
    }

    public static void deleteTagSubtree(final JFrame parent, final ITagManager tagManager, final TreeNode<CTag> tag) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to delete the tag '%s' and all of its children from the database?", tag.getObject().getName())) == 0) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, false);
                        operation.getProgressPanel().setMaximum(1);
                        String string2 = String.valueOf("Deleting tag tree: ");
                        String string3 = String.valueOf(((CTag)tag.getObject()).getName());
                        operation.getProgressPanel().setText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
                        tagManager.deleteTagSubTree(tag);
                        operation.getProgressPanel().next();
                        operation.stop();
                    }
                    catch (CouldntDeleteException e2) {
                        CUtilityFunctions.logException(e2);
                        String innerMessage = "E00146: Could not delete tag tree";
                        String innerDescription = CUtilityFunctions.createDescription(String.format("The tag '%s' and its children could not be deleted.", ((CTag)tag.getObject()).getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The tag and its children were not deleted and can still be used."});
                        NaviErrorDialog.show(parent, "E00146: Could not delete tag tree", innerDescription, e2);
                    }
                }
            }.start();
        }
    }

    public static void insertTag(final JFrame parent, final ITagManager tagManager, final TreeNode<CTag> parentTag, final String name) {
        new Thread(){

            @Override
            public void run() {
                try {
                    CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, false);
                    operation.getProgressPanel().setMaximum(1);
                    String string2 = String.valueOf("Inserting new tag: ");
                    String string3 = String.valueOf(name);
                    operation.getProgressPanel().setText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
                    tagManager.insertTag(parentTag, name);
                    operation.getProgressPanel().next();
                    operation.stop();
                }
                catch (CouldntSaveDataException exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = "E00147: Could not insert tag";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("BinNavi could not insert a new tag with the name '%s'.", name), new String[]{"There was a problem with the database connection."}, new String[]{"The tag was not created."});
                    NaviErrorDialog.show(parent, "E00147: Could not insert tag", innerDescription, exception);
                }
            }
        }.start();
    }
}

