/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Loaders.CProjectLoader;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNameListGenerators;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.INodeSelectionUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.ITreeUpdater;
import com.google.security.zynamics.binnavi.Gui.Progress.CDefaultProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JTree;

public final class CProjectFunctions {
    private CProjectFunctions() {
    }

    private static void createDefaultAddressSpace(JFrame parent, INaviProject newProject) throws CouldntSaveDataException {
        CAddressSpace addressSpace = newProject.getContent().createAddressSpace("Default address space");
        try {
            addressSpace.load();
        }
        catch (CouldntLoadDataException exception) {
            CUtilityFunctions.logException(exception);
            String innerMessage = "E00139: Default address space could not be loaded";
            String innerDescription = CUtilityFunctions.createDescription("The default address space of the new project could not be loaded.", new String[]{"There was a problem with the database connection."}, new String[]{"The new project was created but its default address space could not be loaded."});
            NaviErrorDialog.show(parent, "E00139: Default address space could not be loaded", innerDescription, exception);
        }
        catch (LoadCancelledException loadCancelledException) {
            // empty catch block
        }
    }

    public static void addAddressSpace(final Window parent, final INaviProject project, final INodeSelectionUpdater updater) {
        new Thread(){

            @Override
            public void run() {
                CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, true);
                operation.getProgressPanel().setMaximum(2);
                try {
                    operation.getProgressPanel().setText("Creating new address space");
                    operation.getProgressPanel().next();
                    CAddressSpace addressSpace = project.getContent().createAddressSpace("New Address Space");
                    operation.getProgressPanel().setText("Loading new address space");
                    addressSpace.load();
                    operation.getProgressPanel().next();
                    operation.stop();
                    updater.setObject(addressSpace);
                    updater.update();
                }
                catch (CouldntSaveDataException exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = "E00136: Could not add address space";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("It was not possible to add a new address space to the project '%s'.", project.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The address space was not created."});
                    NaviErrorDialog.show(parent, "E00136: Could not add address space", innerDescription, exception);
                }
                catch (CouldntLoadDataException exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = "E00137: Could not load the new address space";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The new address space in project '%s' was created but it could not be loaded.", project.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The address space was created but not loaded."});
                    NaviErrorDialog.show(parent, "E00137: Could not load the new address space", innerDescription, exception);
                }
                catch (LoadCancelledException loadCancelledException) {
                    // empty catch block
                }
            }
        }.start();
    }

    public static void copyView(JFrame parent, INaviProject project, INaviView view) {
        Preconditions.checkNotNull(parent, "IE01835: Parent argument can not be null");
        Preconditions.checkNotNull(project, "IE01836: Project argument can not be null");
        Preconditions.checkNotNull(view, "IE01837: View argument can not be null");
        if (!view.isLoaded()) {
            try {
                view.load();
            }
            catch (CouldntLoadDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00138: View could not be copied because it could not be loaded";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be copied.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The new view was not created."});
                NaviErrorDialog.show(parent, "E00138: View could not be copied because it could not be loaded", innerDescription, e2);
                return;
            }
            catch (CPartialLoadException e3) {
                CUtilityFunctions.logException(e3);
                return;
            }
            catch (LoadCancelledException e4) {
                return;
            }
        }
        project.getContent().createView(view, view.getName(), view.getConfiguration().getDescription());
        view.close();
        try {
            view.save();
        }
        catch (CouldntSaveDataException exception) {
            CUtilityFunctions.logException(exception);
            String innerMessage = "E00206: Could not save view";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The function '%s' could not be saved.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The graph remains unsaved."});
            NaviErrorDialog.show(parent, "E00206: Could not save view", innerDescription, exception);
        }
    }

    public static void createProject(final JFrame parent, final IDatabase database, final INodeSelectionUpdater updater) {
        new Thread(){

            @Override
            public void run() {
                try {
                    CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, true);
                    operation.getProgressPanel().setMaximum(3);
                    operation.getProgressPanel().setText("Creating new project");
                    INaviProject newProject = database.getContent().addProject("New Project");
                    operation.getProgressPanel().next();
                    try {
                        newProject.load();
                    }
                    catch (LoadCancelledException loadCancelledException) {
                        // empty catch block
                    }
                    operation.getProgressPanel().next();
                    CProjectFunctions.createDefaultAddressSpace(parent, newProject);
                    updater.setObject(newProject);
                    updater.update();
                    operation.getProgressPanel().next();
                    operation.stop();
                }
                catch (CouldntSaveDataException exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = "E00140: New project could not be created";
                    String innerDescription = CUtilityFunctions.createDescription("It was not possible to create a new project in the selected database.", new String[]{"There was a problem with the database connection."}, new String[]{"No new project was created in the selected database."});
                    NaviErrorDialog.show(parent, "E00140: New project could not be created", innerDescription, exception);
                }
                catch (CouldntLoadDataException exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = "E00141: New project could not be loaded";
                    String innerDescription = CUtilityFunctions.createDescription("The new project could not be loaded.", new String[]{"There was a problem with the database connection."}, new String[]{"The new project was created but it could not be loaded."});
                    NaviErrorDialog.show(parent, "E00141: New project could not be loaded", innerDescription, exception);
                }
            }
        }.start();
    }

    public static void openProjects(JTree projectTree, INaviProject[] projects) {
        for (INaviProject project : projects) {
            CProjectLoader.loadProject(projectTree, project);
        }
    }

    public static void removeAddressSpace(final JFrame parent, final INaviProject project, INaviAddressSpace[] addressSpaces, final ITreeUpdater updater) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to delete the following address spaces from the project?\n\n%s", CNameListGenerators.getNameList(addressSpaces))) == 0) {
            for (final INaviAddressSpace addressSpace : addressSpaces) {
                new Thread(){

                    @Override
                    public void run() {
                        CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, true);
                        operation.getProgressPanel().setMaximum(1);
                        String string2 = String.valueOf("Removing address space: ");
                        String string3 = String.valueOf(addressSpace.getConfiguration().getName());
                        operation.getProgressPanel().setText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
                        operation.getProgressPanel().next();
                        if (addressSpace.isLoaded()) {
                            addressSpace.close();
                        }
                        if (addressSpace.isLoaded()) {
                            String innerMessage = "E00123: Address space could not be deleted";
                            String innerDescription = CUtilityFunctions.createDescription(String.format("BinNavi could not delete the address space '%s'.", addressSpace.getConfiguration().getName()), new String[]{"BinNavi or one of the active plugins vetoed the deletion operation."}, new String[]{"The address space can not be deleted until the delete operation is not vetoed anymore."});
                            NaviErrorDialog.show(parent, "E00123: Address space could not be deleted", innerDescription);
                        } else {
                            try {
                                project.getContent().removeAddressSpace(addressSpace);
                                updater.update();
                            }
                            catch (CouldntDeleteException exception) {
                                CUtilityFunctions.logException(exception);
                                String innerMessage = "E00143: Address space could not be deleted";
                                String innerDescription = CUtilityFunctions.createDescription("The selected address space could not be deleted.", new String[]{"There was a problem with the database connection."}, new String[]{"The address space was not deleted."});
                                NaviErrorDialog.show(parent, "E00143: Address space could not be deleted", innerDescription, exception);
                            }
                        }
                        operation.stop();
                    }
                }.start();
            }
        }
    }
}

