/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.Loaders.CModuleLoader;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CModuleInitializerOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import java.awt.Window;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public final class CModuleInitializationFunctions {
    private CModuleInitializationFunctions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeModuleInternal(Window parent, INaviModule module) {
        if (!module.getConfiguration().getRawModule().isComplete()) {
            String innerMessage = "E00059: The module could not be initialized because the imported data is incomplete";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The module '%s' could not be initialized.", module.getConfiguration().getName()), new String[]{"The imported data is incomplete because the exporter failed."}, new String[]{"The module was not initialized."});
            NaviErrorDialog.show(parent, "E00059: The module could not be initialized because the imported data is incomplete", innerDescription);
            return;
        }
        if (module.isInitializing()) {
            return;
        }
        CModuleInitializerOperation operation = new CModuleInitializerOperation(module);
        try {
            module.initialize();
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00060: The module could not be initialized";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The module '%s' could not be initialized.", module.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The module was not initialized."});
            NaviErrorDialog.show(parent, "E00060: The module could not be initialized", innerDescription, e2);
            return;
        }
        finally {
            operation.stop();
        }
    }

    public static void initializeAndLoadModule(final JTree projectTree, final INaviModule module) {
        new Thread(){

            @Override
            public void run() {
                CModuleInitializationFunctions.initializeModuleInternal(SwingUtilities.getWindowAncestor(projectTree), module);
                if (module.isInitialized()) {
                    CModuleLoader.loadModule(projectTree, module);
                }
            }
        }.start();
    }

    public static void initializeModule(final JTree projectTree, final INaviModule module) {
        new Thread(){

            @Override
            public void run() {
                CModuleInitializationFunctions.initializeModuleInternal(SwingUtilities.getWindowAncestor(projectTree), module);
            }
        }.start();
    }
}

