/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Loaders.CModuleLoader;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CDatabaseFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CModuleInitializationFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNameListGenerators;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.ITreeUpdater;
import com.google.security.zynamics.binnavi.Gui.Progress.CDefaultProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Importers.CFailedImport;
import com.google.security.zynamics.binnavi.Importers.CImporterFactory;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CViewInserter;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.JFrame;
import javax.swing.JTree;

public final class CModuleFunctions {
    private CModuleFunctions() {
    }

    public static void copyView(JFrame parent, INaviModule module, INaviView view) {
        Preconditions.checkNotNull(parent, "IE01832: Parent argument can not be null");
        Preconditions.checkNotNull(module, "IE01833: Module argument can not be null");
        Preconditions.checkNotNull(view, "IE01834: View argument can not be null");
        if (module.getContent().getViewContainer().hasView(view)) {
            if (!view.isLoaded()) {
                try {
                    view.load();
                }
                catch (CouldntLoadDataException e2) {
                    CUtilityFunctions.logException(e2);
                    String innerMessage = "E00133: View could not be copied";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be copied because it could not be loaded.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The new view was not created."});
                    NaviErrorDialog.show(parent, "E00133: View could not be copied", innerDescription, e2);
                    return;
                }
                catch (CPartialLoadException | LoadCancelledException e3) {
                    CUtilityFunctions.logException(e3);
                    return;
                }
            }
            CView newView = module.getContent().getViewContainer().createView(String.format("Copy of %s", view.getName()), null);
            CViewInserter.insertView(view, newView);
        }
    }

    public static void deleteModules(final JFrame parent, final IDatabase database, INaviModule[] modules, final ITreeUpdater updater) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to delete the following modules from the database?\n\n%s", CNameListGenerators.getNameList(modules))) == 0) {
            for (final INaviModule module : modules) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        CDefaultProgressOperation operation = new CDefaultProgressOperation("", true, false);
                        operation.getProgressPanel().setMaximum(1);
                        String string2 = String.valueOf("Deleting module: ");
                        String string3 = String.valueOf(module.getConfiguration().getName());
                        operation.getProgressPanel().setText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
                        try {
                            database.getContent().delete(module);
                            operation.getProgressPanel().next();
                            updater.update();
                        }
                        catch (CouldntDeleteException e2) {
                            CUtilityFunctions.logException(e2);
                            String message2 = "E00031: Module could not be deleted";
                            String description = CUtilityFunctions.createDescription(String.format("The module '%s' could not be deleted. Try to delete the module again. If the problem persists, disconnect from and reconnect to the database, restart com.google.security.zynamics.binnavi, or contact the BinNavi support.", module.getConfiguration().getName()), new String[]{"Database connection problems."}, new String[]{"The module still exists."});
                            NaviErrorDialog.show(parent, "E00031: Module could not be deleted", description, e2);
                        }
                        finally {
                            operation.stop();
                        }
                    }
                }.start();
            }
        }
    }

    public static void importModule(final JFrame parent, final IDatabase database) {
        new Thread(){

            @Override
            public void run() {
                try {
                    ArrayList<CFailedImport> failedImports = new ArrayList<CFailedImport>();
                    boolean hasImportedModules = CImporterFactory.importModules(parent, database, failedImports);
                    for (CFailedImport failedImport : failedImports) {
                        String message2 = "E00043: IDB file could not be imported";
                        String description = CUtilityFunctions.createDescription(String.format("The IDB file '%s' could not be imported. Please check the stack trace for more information.", failedImport.geFileName()), new String[]{"Database connection problems.", "Bug in the IDB exporter."}, new String[]{"The IDB file was imported partially. A raw module in an incosistent state was created. This raw module should be deleted."});
                        NaviErrorDialog.show(parent, "E00043: IDB file could not be imported", description, failedImport.getImportException());
                    }
                    if (database.isConnected() && hasImportedModules) {
                        CDatabaseFunctions.refreshRawModules(parent, database);
                    }
                }
                catch (FileNotFoundException exception) {
                    CUtilityFunctions.logException(exception);
                    String message3 = "E00034: IDA Pro executable could not be found";
                    String description = CUtilityFunctions.createDescription("The selected IDB file could not be imported because the IDA Pro executable file could not be found.", new String[]{"Invalid IDA Pro executable file specified."}, new String[]{"The IDB file was not imported."});
                    NaviErrorDialog.show(parent, "E00034: IDA Pro executable could not be found", description, exception);
                }
                catch (InterruptedException exception) {
                    CUtilityFunctions.logException(exception);
                    String message4 = "Import of IDB files failed";
                    String description = CUtilityFunctions.createDescription("Importing failed because one of the background workers was interrupted.", new String[]{"Background threads were interrupted."}, new String[]{"One or more IDB files were not imported."});
                    NaviErrorDialog.show(parent, "Import of IDB files failed", description, exception);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException exception) {
                    CUtilityFunctions.logException(exception);
                    String message5 = "Import of IDB files failed";
                    String description = CUtilityFunctions.createDescription("Importing failed because the background workers threw an exception.", new String[]{"Background threads threw an exception."}, new String[]{"One or more IDB files were not imported."});
                    NaviErrorDialog.show(parent, "Import of IDB files failed", description, exception);
                }
            }
        }.start();
    }

    public static void loadModules(JTree projectTree, INaviModule[] modules) {
        for (INaviModule module : modules) {
            if (module.isInitialized()) {
                CModuleLoader.loadModule(projectTree, module);
                continue;
            }
            CModuleInitializationFunctions.initializeAndLoadModule(projectTree, module);
        }
    }
}

