/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.disassembly.CCallgraph;
import com.google.security.zynamics.binnavi.disassembly.CFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphEdge;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphNode;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CFunctionNodeColorizer;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import java.util.HashMap;
import java.util.List;

public final class CCallgraphCombiner {
    private CCallgraphCombiner() {
    }

    private static INaviFunction getResolvedFunction(INaviFunction function, List<INaviModule> modules) {
        if (function.getForwardedFunctionAddress() == null) {
            return null;
        }
        for (INaviModule module : modules) {
            if (module.getConfiguration().getId() != function.getForwardedFunctionModuleId()) continue;
            return module.getContent().getFunctionContainer().getFunction(function.getForwardedFunctionAddress());
        }
        return null;
    }

    public static INaviView createCombinedCallgraph(INaviProject project, INaviAddressSpace addressSpace) {
        CCallgraph callgraph;
        INaviView view = project.getContent().createView("Combined Callgraph", "");
        HashMap<INaviFunction, CFunctionNode> nodeMap = new HashMap<INaviFunction, CFunctionNode>();
        HashMap<INaviFunction, INaviFunction> resolvedMap = new HashMap<INaviFunction, INaviFunction>();
        List<INaviModule> modules = addressSpace.getContent().getModules();
        for (INaviModule module : modules) {
            callgraph = module.getContent().getNativeCallgraph();
            for (ICallgraphNode callgraphNode : callgraph) {
                INaviFunction function = callgraphNode.getFunction();
                INaviFunction resolvedFunction = CCallgraphCombiner.getResolvedFunction(function, modules);
                if (resolvedFunction == null) {
                    CFunctionNode node = view.getContent().createFunctionNode(function);
                    node.setColor(CFunctionNodeColorizer.getFunctionColor(function.getType()));
                    nodeMap.put(function, node);
                    continue;
                }
                resolvedMap.put(function, resolvedFunction);
            }
        }
        for (INaviModule module : modules) {
            callgraph = module.getContent().getNativeCallgraph();
            for (ICallgraphEdge callgraphEdge : callgraph.getEdges()) {
                INaviFunction source = resolvedMap.containsKey(((ICallgraphNode)callgraphEdge.getSource()).getFunction()) ? (INaviFunction)resolvedMap.get(((ICallgraphNode)callgraphEdge.getSource()).getFunction()) : ((ICallgraphNode)callgraphEdge.getSource()).getFunction();
                INaviFunction target = resolvedMap.containsKey(((ICallgraphNode)callgraphEdge.getTarget()).getFunction()) ? (INaviFunction)resolvedMap.get(((ICallgraphNode)callgraphEdge.getTarget()).getFunction()) : ((ICallgraphNode)callgraphEdge.getTarget()).getFunction();
                view.getContent().createEdge((INaviViewNode)nodeMap.get(source), (INaviViewNode)nodeMap.get(target), EdgeType.JUMP_UNCONDITIONAL);
            }
        }
        return view;
    }
}

