/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Loaders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import javax.swing.JFrame;

public final class CViewLoader {
    private CViewLoader() {
    }

    public static void load(JFrame parent, IViewContainer container, INaviView view) {
        Preconditions.checkNotNull(parent, "IE00011: Parent argument can not be null");
        Preconditions.checkNotNull(container, "IE00012: Container argument can not be null");
        Preconditions.checkNotNull(view, "IE00013: View argument can not be null");
        if (view.isLoaded()) {
            return;
        }
        ViewLoaderThread thread2 = new ViewLoaderThread(view);
        CProgressDialog.showEndless(parent, String.format("Loading view '%s'", view.getName()), thread2);
        Exception exception = thread2.getException();
        if (exception != null) {
            if (exception instanceof CouldntLoadDataException) {
                CUtilityFunctions.logException(exception);
                String message2 = "E00050: Could not load view";
                String description = CUtilityFunctions.createDescription(String.format("The view '%s' could not be loaded.", view.getName()), new String[]{"There were problems with the database connection.", "Malformed data was found in the database."}, new String[]{"The view was not loaded."});
                NaviErrorDialog.show(parent, "E00050: Could not load view", description, exception);
            } else if (exception instanceof CPartialLoadException) {
                CUtilityFunctions.logException(exception);
                String moduleName = ((CPartialLoadException)exception).getModule().getConfiguration().getName();
                String message3 = "E00051: Could not load view";
                String description = CUtilityFunctions.createDescription(String.format("The view '%s' could not be loaded because it depends on the unloaded module '%s'.", view.getName(), moduleName), new String[]{String.format("Module '%s' is not loaded.", moduleName)}, new String[]{String.format("The view can not be loaded before the module '%s' is loaded.", moduleName)});
                NaviErrorDialog.show(parent, "E00051: Could not load view", description, exception);
            }
        }
    }

    private static class ViewLoaderThread
    extends CEndlessHelperThread {
        private final INaviView m_view;

        private ViewLoaderThread(INaviView view) {
            this.m_view = Preconditions.checkNotNull(view, "IE00014: View argument can not be null");
        }

        @Override
        protected void runExpensiveCommand() throws Exception {
            this.m_view.load();
        }
    }
}

