/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Loaders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNodeExpander;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.IProjectListener;
import com.google.security.zynamics.binnavi.disassembly.ProjectLoadEvents;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.awt.Window;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public final class CProjectLoader {
    private CProjectLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProjectInternal(Window parent, final INaviProject project, final JTree projectTree) {
        CProjectLoaderOperation operation = new CProjectLoaderOperation(project);
        try {
            project.load();
            if (projectTree != null) {
                new SwingInvoker(){

                    @Override
                    protected void operation() {
                        CNodeExpander.expandNode(projectTree, project);
                    }
                }.invokeLater();
            }
        }
        catch (CouldntLoadDataException exception) {
            CUtilityFunctions.logException(exception);
            String message2 = "E00178: Project data could not be loaded";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not load the project '%s'.", project.getConfiguration().getName()), new String[]{"The connection dropped while the data was loaded."}, new String[]{"BinNavi can not open the project. To fix this situation try to load the project again. Restart BinNavi if necessary and contact the BinNavi support if the problem persists."});
            NaviErrorDialog.show(parent, "E00178: Project data could not be loaded", description, exception);
        }
        catch (LoadCancelledException loadCancelledException) {
        }
        finally {
            operation.stop();
        }
    }

    private static void loadProjectThreaded(final Window parent, final INaviProject project, final JTree projectTree) {
        Preconditions.checkNotNull(parent, "IE00005: Parent argument can not be null");
        Preconditions.checkNotNull(project, "IE01284: Project argument can not be null");
        if (project.isLoading()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                CProjectLoader.loadProjectInternal(parent, project, projectTree);
            }
        }.start();
    }

    public static void loadProject(JTree tree, INaviProject project) {
        Preconditions.checkNotNull(tree, "IE01435: Tree argument can not be null");
        Preconditions.checkNotNull(project, "IE01436: Project argument can not be null");
        CProjectLoader.loadProjectThreaded(SwingUtilities.getWindowAncestor(tree), project, tree);
    }

    private static class CProjectLoaderOperation
    implements IProgressOperation {
        private final INaviProject m_project;
        private final CProgressPanel m_progressPanel = new CProgressPanel("", false, true){
            private static final long serialVersionUID = -1163585238482641129L;

            @Override
            protected void closeRequested() {
                this.setText("Cancelling project loading");
                m_continue = false;
            }
        };
        private boolean m_continue = true;
        private final IProjectListener m_listener = new CProjectListenerAdapter(){
            private boolean m_first = true;

            @Override
            public boolean loading(ProjectLoadEvents event, int counter) {
                if (!m_continue) {
                    m_continue = true;
                    return false;
                }
                m_progressPanel.next();
                if (event == ProjectLoadEvents.Finished) {
                    m_progressPanel.setVisible(false);
                    this.m_first = true;
                    m_continue = true;
                } else if (this.m_first) {
                    m_progressPanel.setText("Loading project");
                    m_progressPanel.setMaximum(ProjectLoadEvents.values().length);
                    m_progressPanel.setValue(counter);
                    this.m_first = false;
                }
                return true;
            }
        };

        public CProjectLoaderOperation(INaviProject project) {
            this.m_project = project;
            CGlobalProgressManager.instance().add(this);
            project.addListener(this.m_listener);
        }

        @Override
        public String getDescription() {
            return "Loading project";
        }

        @Override
        public CProgressPanel getProgressPanel() {
            return this.m_progressPanel;
        }

        public void stop() {
            this.m_project.removeListener(this.m_listener);
            CGlobalProgressManager.instance().remove(this);
        }
    }
}

