/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Loaders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNodeExpander;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.Modules.IModuleListener;
import com.google.security.zynamics.binnavi.disassembly.Modules.ModuleLoadEvents;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.awt.Window;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public final class CModuleLoader {
    private CModuleLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadModuleInternal(Window parent, final INaviModule module, final JTree projectTree) {
        final CModuleLoaderOperation operation = new CModuleLoaderOperation(module);
        boolean success = false;
        try {
            if (projectTree != null) {
                CNodeExpander.findNode(projectTree, module).getComponent();
            }
            module.load();
            success = true;
            if (projectTree != null) {
                new SwingInvoker(){

                    @Override
                    protected void operation() {
                        CNodeExpander.expandNode(projectTree, module);
                        operation.stop();
                    }
                }.invokeLater();
            }
        }
        catch (CouldntLoadDataException exception) {
            CUtilityFunctions.logException(exception);
            String message2 = "E00177: Module data could not be loaded";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not load the module '%s'.", module.getConfiguration().getName()), new String[]{"The connection dropped while the data was loaded."}, new String[]{"BinNavi can not open the module. To fix this situation try to load the module again. Restart BinNavi if necessary and contact the BinNavi support if the problem persists."});
            NaviErrorDialog.show(parent, "E00177: Module data could not be loaded", description, exception);
        }
        catch (LoadCancelledException loadCancelledException) {
        }
        finally {
            if (!success) {
                operation.stop();
            }
        }
    }

    private static void loadModuleThreaded(final Window parent, final INaviModule module, final JTree projectTree) {
        Preconditions.checkNotNull(parent, "IE01193: Parent argument can not be null");
        Preconditions.checkNotNull(module, "IE01194: Module argument can not be null");
        if (module.isLoading()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                CModuleLoader.loadModuleInternal(parent, module, projectTree);
            }
        }.start();
    }

    public static void loadModule(JTree tree, INaviModule module) {
        Preconditions.checkNotNull(tree, "IE01195: Tree argument can not be null");
        Preconditions.checkNotNull(module, "IE01196: Module argument can not be null");
        CModuleLoader.loadModuleThreaded(SwingUtilities.getWindowAncestor(tree), module, tree);
    }

    public static void loadModule(Window parent, INaviModule module) {
        Preconditions.checkNotNull(parent, "IE01197: Parent argument can not be null");
        Preconditions.checkNotNull(module, "IE01278: Module argument can not be null");
        CModuleLoader.loadModuleThreaded(parent, module, null);
    }

    private static class CModuleLoaderOperation
    implements IProgressOperation {
        private final INaviModule m_module;
        private final CProgressPanel m_progressPanel = new CProgressPanel("", false, true){
            private static final long serialVersionUID = 81245428645703865L;

            @Override
            protected void closeRequested() {
                this.setText("Cancelling module conversion");
                m_continue = false;
            }
        };
        private boolean m_continue = true;
        private final IModuleListener m_listener = new CModuleListenerAdapter(){
            private boolean m_first = true;

            @Override
            public boolean loading(ModuleLoadEvents event, int counter) {
                if (!m_continue) {
                    m_continue = true;
                    return false;
                }
                m_progressPanel.next();
                if (event == ModuleLoadEvents.Finished) {
                    m_progressPanel.setVisible(false);
                    this.m_first = true;
                    m_continue = true;
                } else if (this.m_first) {
                    String string2 = String.valueOf("Loading module: ");
                    String string3 = String.valueOf(m_module.getConfiguration().getName());
                    m_progressPanel.setText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
                    m_progressPanel.setMaximum(ModuleLoadEvents.values().length);
                    m_progressPanel.setValue(counter);
                    this.m_first = false;
                }
                return true;
            }
        };

        public CModuleLoaderOperation(INaviModule module) {
            this.m_module = module;
            CGlobalProgressManager.instance().add(this);
            module.addListener(this.m_listener);
        }

        @Override
        public String getDescription() {
            return "Loading Module";
        }

        @Override
        public CProgressPanel getProgressPanel() {
            return this.m_progressPanel;
        }

        public void stop() {
            this.m_module.removeListener(this.m_listener);
            CGlobalProgressManager.instance().remove(this);
        }
    }
}

