/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.IdaSelectionDialog;

import com.google.security.zynamics.binnavi.Gui.IdaSelectionDialog.CBinExportInstallationChecker;
import com.google.security.zynamics.binnavi.Gui.IdaSelectionDialog.CBinExportInstaller;
import com.google.security.zynamics.binnavi.Gui.IdaSelectionDialog.InstallationState;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class CIdaSelectionDialog
extends JDialog {
    private final JLabel m_cppStateLabel = new JLabel("");
    private final JButton m_cppButton = new JButton(new CppInstallerAction());
    private final JFileChooser m_chooser = new JFileChooser(){

        @Override
        public void approveSelection() {
            CIdaSelectionDialog.this.approve();
        }

        @Override
        public void cancelSelection() {
            CIdaSelectionDialog.this.cancel();
        }
    };
    private File m_selectedFile = null;

    private CIdaSelectionDialog(Window parent, String initialDirectory) {
        super(parent, "IDA Pro Selection", Dialog.ModalityType.APPLICATION_MODAL);
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.m_chooser.setControlButtonsAreShown(false);
        this.m_chooser.addPropertyChangeListener("directoryChanged", new DirectoryChangedListener());
        this.m_chooser.setCurrentDirectory(new File(initialDirectory));
        this.m_chooser.setFileSelectionMode(1);
        this.m_chooser.setAcceptAllFileFilterUsed(false);
        this.add(this.m_chooser);
        JPanel lowerPanel = new JPanel(new BorderLayout());
        CPanelTwoButtons buttonPanel = new CPanelTwoButtons(new InternalActionListener(), "OK", "Cancel");
        lowerPanel.add((Component)buttonPanel, "East");
        JPanel cppPanel = new JPanel(new GridLayout(1, 2));
        cppPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel install2 = new JPanel();
        install2.add(this.m_cppButton);
        JLabel exporterLabel = new JLabel("BinExport IDA plugin: ");
        exporterLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        cppPanel.add(exporterLabel);
        cppPanel.add(this.m_cppStateLabel);
        cppPanel.add(install2);
        lowerPanel.add((Component)cppPanel, "Center");
        this.add((Component)lowerPanel, "South");
        this.updateDialog(this.m_chooser.getCurrentDirectory());
        this.pack();
    }

    private static String getText(InstallationState state) {
        switch (state) {
            case Installed: {
                return "Installed";
            }
            case InvalidIdaDirectory: {
                return "Invalid IDA Directory";
            }
            case NotInstalled: {
                return "Not Installed";
            }
        }
        throw new IllegalStateException("IE00683: Unknown state");
    }

    public static CIdaSelectionDialog show(Window parent, String initialDirectory) {
        CIdaSelectionDialog dlg = new CIdaSelectionDialog(parent, initialDirectory);
        GuiHelper.centerChildToParent(parent, dlg, true);
        dlg.setVisible(true);
        return dlg;
    }

    private void approve() {
        if (this.m_chooser.getCurrentDirectory() == null) {
            return;
        }
        ConfigManager configFile = ConfigManager.instance();
        if (InstallationState.Installed.equals((Object)CBinExportInstallationChecker.getState(this.m_chooser.getCurrentDirectory())) && configFile.getGeneralSettings().getIdaDirectory().equals(this.m_chooser.getCurrentDirectory())) {
            CMessageBox.showInformation(this, "Settings unchanged.");
            this.dispose();
            return;
        }
        InstallationState cppState = CBinExportInstallationChecker.getState(this.m_chooser.getSelectedFile());
        if (cppState != InstallationState.Installed) {
            CMessageBox.showError(this, "Please install the BinExport IDA plugin.");
            return;
        }
        this.m_selectedFile = this.m_chooser.getSelectedFile();
        this.dispose();
    }

    private void cancel() {
        this.dispose();
    }

    private void updateDialog(File directory) {
        InstallationState cppState = CBinExportInstallationChecker.getState(directory);
        this.m_cppStateLabel.setText(CIdaSelectionDialog.getText(cppState));
        this.m_cppButton.setEnabled(cppState == InstallationState.NotInstalled);
    }

    public File getSelectedFile() {
        return this.m_selectedFile;
    }

    private final class InternalActionListener
    implements ActionListener {
        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("OK")) {
                CIdaSelectionDialog.this.approve();
            } else {
                CIdaSelectionDialog.this.cancel();
            }
        }
    }

    private class DirectoryChangedListener
    implements PropertyChangeListener {
        private DirectoryChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CIdaSelectionDialog.this.updateDialog(CIdaSelectionDialog.this.m_chooser.getCurrentDirectory());
        }
    }

    private class CppInstallerAction
    extends AbstractAction {
        private static final long serialVersionUID = -349623644472351194L;

        public CppInstallerAction() {
            super("Install");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CBinExportInstaller.install(CIdaSelectionDialog.this, CIdaSelectionDialog.this.m_chooser.getCurrentDirectory());
            CIdaSelectionDialog.this.updateDialog(CIdaSelectionDialog.this.m_chooser.getCurrentDirectory());
        }
    }
}

