/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.IdaSelectionDialog;

import com.google.common.io.ByteStreams;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.IdaSelectionDialog.CBinExportFiles;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CBinExportInstaller {
    private CBinExportInstaller() {
    }

    private static void copyFile(File directory, String file) throws FileNotFoundException, IOException {
        String string2 = String.valueOf(file);
        InputStream inFile = CMain.class.getResourceAsStream(string2.length() != 0 ? "exporters/BinExport/".concat(string2) : new String("exporters/BinExport/"));
        String string3 = String.valueOf(directory.getAbsolutePath());
        FileOutputStream outFile = new FileOutputStream(new StringBuilder(9 + String.valueOf(string3).length() + String.valueOf(file).length()).append(string3).append("/plugins/").append(file).toString());
        ByteStreams.copy(inFile, outFile);
        inFile.close();
        outFile.close();
    }

    private static void handleException(Window parent, Exception exception) {
        String innerMessage = "E00041: Could not install BinExport";
        String innerDescription = CUtilityFunctions.createDescription("BinNavi could not install the BinExport because one of more files could not be copied.", new String[]{"Insufficient rights to write to the IDA Pro directory", "Some kind of IO problem occurred"}, new String[]{"BinExport was not installed and can not be used to export IDB files to the database. You can try to install BinExport manually by copying the exporters/BinExport directory from your BinNavi installation to the IDA Pro directory."});
        NaviErrorDialog.show(parent, "E00041: Could not install BinExport", innerDescription, exception);
    }

    private static void install(File directory) throws FileNotFoundException, IOException {
        File pluginsDirectory = new File(String.valueOf(directory.getAbsolutePath()).concat("/plugins"));
        for (String pluginFile : CBinExportFiles.getPluginFiles()) {
            if (FileUtils.containsFile(pluginsDirectory, pluginFile)) continue;
            CBinExportInstaller.copyFile(directory, pluginFile);
        }
    }

    public static void install(Window parent, File directory) {
        try {
            CBinExportInstaller.install(directory);
            CMessageBox.showInformation(parent, "Installation successful");
        }
        catch (FileNotFoundException e2) {
            CUtilityFunctions.logException(e2);
            CBinExportInstaller.handleException(parent, e2);
        }
        catch (IOException e3) {
            CUtilityFunctions.logException(e3);
            CBinExportInstaller.handleException(parent, e3);
        }
    }
}

