/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.HotkeyDialog;

import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.HotkeyDialog.CLeftTitle;
import com.google.security.zynamics.binnavi.Gui.HotkeyDialog.CRightTitle;
import com.google.security.zynamics.binnavi.Gui.HotkeyDialog.HotKey;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public final class CGraphWindowHotkeyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4174902701474843040L;
    private static final String[] COLUMN_NAMES = new String[]{"Hotkey", "Description"};
    private static final ArrayList<Object[]> hotKeys = new ArrayList();

    private static Object[] makeTitle(String titleString) {
        return new Object[]{new CLeftTitle(titleString.substring(0, titleString.length() / 2)), new CRightTitle(titleString.substring(titleString.length() / 2))};
    }

    private static void fillTable() {
        hotKeys.clear();
        hotKeys.add(CGraphWindowHotkeyTableModel.makeTitle("Graph"));
        CGraphWindowHotkeyTableModel.loadKeys(HotKeys.graphHotKeys);
        hotKeys.add(CGraphWindowHotkeyTableModel.makeTitle("Graph Misc"));
        hotKeys.add(new Object[]{"Alt-Right Click", "Opens instruction comments dialog when clicking on an instruction"});
        hotKeys.add(new Object[]{"Shift+Alt-Right Click", "Opens instruction comments dialog when clicking on an instruction"});
        hotKeys.add(new Object[]{"Ctrl+Alt-Right Click", "Highlights instruction when clicking on an instruction."});
        hotKeys.add(CGraphWindowHotkeyTableModel.makeTitle("Graph toolbar"));
        CGraphWindowHotkeyTableModel.loadKeys(HotKeys.graphToolbarHotKeys);
        hotKeys.add(CGraphWindowHotkeyTableModel.makeTitle("Graph mouse interaction"));
        hotKeys.add(new Object[]{"Mouse wheel", "Zoom to mouse cursor"});
        hotKeys.add(new Object[]{"Shift-Mouse wheel", "Zoom to selection"});
        hotKeys.add(new Object[]{"Ctrl-Mouse wheel", "Scroll vertically"});
        hotKeys.add(new Object[]{"Ctrl-Alt-Mouse wheel", "Scroll horizontally"});
        hotKeys.add(new Object[]{"Ctrl-Mouse wheel", "Resize the magnifying glass"});
        hotKeys.add(new Object[]{"CTRL-DOUBLE-LEFTCLICK", "Opens function when clicking on function nodes"});
        hotKeys.add(new Object[]{"CTRL-DOUBLE-LEFTCLICK", "Opens function when clicking on function calls in code nodes"});
        hotKeys.add(new Object[]{"MOUSEWHEEL-Click", "Sets the focus into a node"});
        hotKeys.add(new Object[]{"ALT-LEFTCLICK", "Sets the focus into a node"});
        hotKeys.add(new Object[]{"SHIFT-ARROWKEYS", "Select the content of a node once the node has the focus"});
        hotKeys.add(CGraphWindowHotkeyTableModel.makeTitle("Generic"));
        CGraphWindowHotkeyTableModel.loadKeys(HotKeys.genericHotKeys);
        hotKeys.add(CGraphWindowHotkeyTableModel.makeTitle("Debugger"));
        CGraphWindowHotkeyTableModel.loadKeys(HotKeys.debuggerHotKeys);
        hotKeys.add(CGraphWindowHotkeyTableModel.makeTitle("Database dialog"));
        CGraphWindowHotkeyTableModel.loadKeys(HotKeys.dbHotKeys);
        hotKeys.add(CGraphWindowHotkeyTableModel.makeTitle("Main window"));
        CGraphWindowHotkeyTableModel.loadKeys(HotKeys.mainWindowHotKeys);
    }

    private static void loadKeys(ImmutableList<HotKey> list) {
        for (HotKey currentHotKey : list) {
            String modifiers = currentHotKey.getKeyStroke().getModifiers() != 0 ? String.valueOf(KeyEvent.getModifiersExText(currentHotKey.getKeyStroke().getModifiers())).concat("-") : "";
            Object[] objectArray = new Object[2];
            String string2 = String.valueOf(modifiers);
            String string3 = String.valueOf(KeyEvent.getKeyText(currentHotKey.getKeyStroke().getKeyCode()));
            objectArray[0] = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            objectArray[1] = currentHotKey.getDescription();
            hotKeys.add(objectArray);
        }
    }

    public CGraphWindowHotkeyTableModel() {
        CGraphWindowHotkeyTableModel.fillTable();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int index) {
        return COLUMN_NAMES[index];
    }

    @Override
    public int getRowCount() {
        return hotKeys.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return hotKeys.get(row)[col];
    }
}

