/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types.actions;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberDialog;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class InsertMemberAction
extends AbstractAction {
    private final JFrame owner;
    private final TypeManager typeManager;
    private final TypeMember existingMember;

    public InsertMemberAction(JFrame owner, TypeManager typeManager, TypeMember existingMember) {
        super(String.format("Insert member after '%s'", existingMember.getName()));
        this.owner = owner;
        this.typeManager = typeManager;
        this.existingMember = existingMember;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        MemberDialog dlg = MemberDialog.createBuildNewMemberDialog(this.owner, this.typeManager);
        dlg.setVisible(true);
        if (!dlg.wasCanceled()) {
            BaseType memberType = dlg.getBaseType();
            String memberName = dlg.getMemberName();
            try {
                this.typeManager.insertMemberAfter(this.existingMember, memberType, memberName);
            }
            catch (CouldntSaveDataException exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

