/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.BaseTypeTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberNodeTransferHandler;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeMemberTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypesTreeModel;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.jtree.IconNodeRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class TypesTree
extends JTree {
    public TypesTree() {
        this.setRootVisible(false);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.setToggleClickCount(1);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(4);
        this.setSelectionModel(selectionModel);
        IconNodeRenderer renderer = new IconNodeRenderer();
        renderer.setFont(GuiHelper.MONOSPACED_FONT);
        this.setCellRenderer(renderer);
    }

    private static TypesTree CreateDragAndDropTypesTree(TypeManager typeManager) {
        TypesTree typesTree = new TypesTree();
        typesTree.setTransferHandler(new MemberNodeTransferHandler(typesTree, typeManager));
        return typesTree;
    }

    private static void unfoldFirstNode(TypesTree typesTree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)typesTree.getModel().getRoot();
        if (root != null && root.getChildCount() > 0 && root.getFirstChild().getChildCount() > 0) {
            typesTree.setSelectionPath(new TreePath(typesTree.getModel().getPathToRoot(root.getFirstChild().getChildAt(0))));
        }
    }

    public static TypesTree createDefaultDndTypesTree(TypeManager typeManager) {
        Preconditions.checkNotNull(typeManager, "Error: typeManager argument can not be null");
        TypesTree typesTree = TypesTree.CreateDragAndDropTypesTree(typeManager);
        typesTree.setModel(TypesTreeModel.createDefaultModel(typeManager));
        return typesTree;
    }

    public static TypesTree createStackFrameDndTypesTree(INaviFunction function, TypeManager typeManager) {
        Preconditions.checkNotNull(function, "Error: function argument can not be null");
        Preconditions.checkNotNull(typeManager, "Error: typeManager argument can not be null");
        TypesTree typesTree = TypesTree.CreateDragAndDropTypesTree(typeManager);
        TypesTreeModel model = function.getStackFrame() == null ? TypesTreeModel.createEmptyTypeModel() : TypesTreeModel.createSingleTypeModel(typeManager, function.getStackFrame());
        typesTree.setModel(model);
        TypesTree.unfoldFirstNode(typesTree);
        return typesTree;
    }

    public static TypesTree createPrototypeDndTypesTree(INaviFunction function, TypeManager typeManager) {
        Preconditions.checkNotNull(function, "Error: function argument can not be null");
        Preconditions.checkNotNull(typeManager, "Error: typeManager argument can not be null");
        TypesTree typesTree = TypesTree.CreateDragAndDropTypesTree(typeManager);
        TypesTreeModel model = function.getPrototype() == null ? TypesTreeModel.createEmptyTypeModel() : TypesTreeModel.createSingleTypeModel(typeManager, function.getPrototype());
        typesTree.setModel(model);
        TypesTree.unfoldFirstNode(typesTree);
        return typesTree;
    }

    public TypeSelectionPath determineTypePath() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        if (path == null || path.getPathCount() == 0) {
            return new TypeSelectionPath(null, new ArrayList<TypeMember>());
        }
        Object[] nodes = path.getPath();
        BaseType rootType = ((BaseTypeTreeNode)nodes[1]).getBaseType();
        ArrayList<TypeMember> memberPath = Lists.newArrayList();
        for (int i2 = 2; i2 < path.getPathCount(); ++i2) {
            memberPath.add(((TypeMemberTreeNode)nodes[i2]).getTypeMember());
        }
        return new TypeSelectionPath(rootType, memberPath);
    }

    @Override
    public TypesTreeModel getModel() {
        return (TypesTreeModel)super.getModel();
    }

    public class TypeSelectionPath {
        private final BaseType rootType;
        private final List<TypeMember> members;
        private final boolean containsUnion;

        public TypeSelectionPath(BaseType rootType, List<TypeMember> members) {
            this.rootType = rootType;
            this.members = members;
            this.containsUnion = rootType == null ? false : this.containsUnion(rootType, members);
        }

        public BaseType getRootType() {
            return this.rootType;
        }

        public List<TypeMember> getMembers() {
            return this.members;
        }

        public boolean hasSelection() {
            return this.rootType != null;
        }

        public boolean containsUnion() {
            return this.containsUnion;
        }

        private boolean containsUnion(BaseType rootType, List<TypeMember> members) {
            if (rootType.getCategory() == BaseTypeCategory.UNION) {
                return true;
            }
            for (TypeMember member : members) {
                if (member.getBaseType().getCategory() != BaseTypeCategory.UNION) continue;
                return true;
            }
            return false;
        }

        public int determineTotalMemberOffset() {
            if (this.containsBaseTypeOnly()) {
                return 0;
            }
            int offset = 0;
            for (TypeMember member : this.members) {
                offset += member.getBitOffset().get().intValue();
            }
            return offset;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.rootType.getName());
            for (TypeMember member : this.members) {
                builder.append('.');
                builder.append(member.getName());
            }
            return builder.toString();
        }

        public boolean containsBaseTypeOnly() {
            return this.members.isEmpty();
        }
    }
}

