/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeSystemIcons;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.zylib.gui.jtree.IconNode;
import javax.swing.ImageIcon;

public class TypeMemberTreeNode
extends IconNode {
    private final TypeMember typeMember;

    public TypeMemberTreeNode(TypeMember member) {
        this.typeMember = member;
        this.setIcon(this.determineIcon(this.typeMember));
    }

    private ImageIcon determineIcon(TypeMember typeMember) {
        switch (typeMember.getBaseType().getCategory()) {
            case ATOMIC: {
                return TypeSystemIcons.ATOMIC_ICON;
            }
            case POINTER: {
                return TypeSystemIcons.POINTER_ICON;
            }
            case ARRAY: {
                return TypeSystemIcons.ARRAY_ICON;
            }
            case STRUCT: {
                return TypeSystemIcons.STRUCT_ICON;
            }
            case UNION: {
                return TypeSystemIcons.UNION_ICON;
            }
            case FUNCTION_PROTOTYPE: {
                return TypeSystemIcons.FUNCTION_POINTER_ICON;
            }
        }
        return null;
    }

    public TypeMember getTypeMember() {
        return this.typeMember;
    }

    @Override
    public String toString() {
        if (this.getTypeMember().isOffsetType()) {
            return String.format("+%d %s %s", this.getTypeMember().getByteOffset().get(), this.getTypeMember().getBaseType().getName(), this.getTypeMember().getName());
        }
        if (this.getTypeMember().isIndexType()) {
            String string2;
            if (this.getTypeMember().getArgumentIndex().get() == 0) {
                string2 = "ret";
            } else {
                String string3 = String.valueOf(String.valueOf(this.getTypeMember().getArgumentIndex().get() - 1));
                string2 = string3.length() != 0 ? "arg_".concat(string3) : new String("arg_");
            }
            String argument_prefix = string2;
            return String.format("[%s] %s %s", argument_prefix, this.getTypeMember().getBaseType().getName(), this.getTypeMember().getName());
        }
        throw new IllegalStateException("Error: can not render type member tree node");
    }

    public void updateIcon() {
        this.setIcon(this.determineIcon(this.typeMember));
    }
}

