/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class TypeListModel
extends AbstractListModel<BaseType>
implements ComboBoxModel<BaseType> {
    private BaseType selectedType;
    private final ImmutableList<BaseType> filteredTypes;

    public TypeListModel(List<BaseType> types2, Predicate<BaseType> filter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BaseType baseType : types2) {
            if (!filter.apply(baseType)) continue;
            builder.add(baseType);
        }
        this.filteredTypes = builder.build();
    }

    @Override
    public BaseType getElementAt(int index) {
        return (BaseType)this.filteredTypes.get(index);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedType;
    }

    @Override
    public int getSize() {
        return this.filteredTypes.size();
    }

    public void selectByBaseType(BaseType baseType) {
        int index = this.filteredTypes.indexOf(baseType);
        if (index != -1) {
            this.setSelectedItem(baseType);
        }
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedType = (BaseType)anItem;
    }

    public static class ArrayTypesFilter
    implements Predicate<BaseType> {
        @Override
        public boolean apply(BaseType baseType) {
            return baseType.getCategory() != BaseTypeCategory.ARRAY;
        }
    }

    public static class PrototypesFilter
    implements Predicate<BaseType> {
        @Override
        public boolean apply(BaseType baseType) {
            return baseType.getCategory() != BaseTypeCategory.FUNCTION_PROTOTYPE;
        }
    }
}

