/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Module.Component.CModuleNodeComponent;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;

public class TypeInstanceReferencesDialog
extends JDialog {
    private boolean wasCancelled = true;
    private JTable xrefs;
    private final MouseListener internalMouseListener = new CrossreferenceTableMouseListener();

    public TypeInstanceReferencesDialog(JFrame owner, List<TypeInstanceReference> references) {
        super(owner, "Cross references", false);
        this.createControls(references);
        new CDialogEscaper(this);
        this.pack();
        GuiHelper.centerChildToParent(owner, this, true);
    }

    private void createControls(List<TypeInstanceReference> references) {
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout(new FlowLayout(2));
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TypeInstanceReferencesDialog.this.wasCancelled = false;
                TypeInstanceReferencesDialog.this.dispose();
            }
        });
        panel.add(buttonOk);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TypeInstanceReferencesDialog.this.dispose();
            }
        });
        panel.add(buttonCancel);
        this.xrefs = new JTable(new XRefsTableModel(references));
        this.xrefs.addMouseListener(this.internalMouseListener);
        this.xrefs.setSelectionMode(0);
        this.xrefs.setRowSelectionInterval(0, 0);
        JPanel tablePanel = new JPanel(new BorderLayout(5, 5));
        tablePanel.setBorder(new TitledBorder("Cross references"));
        tablePanel.add((Component)new JScrollPane(this.xrefs), "Center");
        this.add((Component)tablePanel, "Center");
    }

    public TypeInstanceReference getSelectedXRef() {
        if (this.xrefs.getSelectedRow() != -1) {
            return ((XRefsTableModel)this.xrefs.getModel()).getXRef(this.xrefs.getSelectedRow());
        }
        return null;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    private class XRefsTableModel
    extends AbstractTableModel {
        private final List<TypeInstanceReference> references;
        private final String[] COLUMN_NAMES = new String[]{"Source", "Destination", "Section"};
        private static final int SOURCE_COLUMN = 0;
        private static final int DESTINATION_COLUMN = 1;
        private static final int SECTION_COLUMN = 2;

        public XRefsTableModel(List<TypeInstanceReference> references) {
            this.references = references;
        }

        private String getDestinationAddress(int rowIndex) {
            return String.format("0x%X", this.references.get(rowIndex).getTypeInstance().getAddress().getVirtualAddress());
        }

        private String getSection(int rowIndex) {
            return this.references.get(rowIndex).getTypeInstance().getSection().getName();
        }

        private String getSourceAddress(int rowIndex) {
            return this.references.get(rowIndex).getAddress().toHexString();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Source address";
                }
                case 1: {
                    return "Destination address";
                }
                case 2: {
                    return "Section";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.references.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getSourceAddress(rowIndex);
                }
                case 1: {
                    return this.getDestinationAddress(rowIndex);
                }
                case 2: {
                    return this.getSection(rowIndex);
                }
            }
            return null;
        }

        public TypeInstanceReference getXRef(int rowIndex) {
            return this.references.get(rowIndex);
        }
    }

    private class CrossreferenceTableMouseListener
    implements MouseListener {
        private CrossreferenceTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            XRefsTableModel model = (XRefsTableModel)TypeInstanceReferencesDialog.this.xrefs.getModel();
            TypeInstanceReference reference = model.getXRef(TypeInstanceReferencesDialog.this.xrefs.getSelectedRow());
            CModuleNodeComponent.focusTypeInstance(reference.getTypeInstance().getModule(), reference.getTypeInstance());
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }
    }
}

