/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.ArrayTypePanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.AtomicTypePanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.PointerTypePanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.PrototypeTypePanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.StructureTypePanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeDialogPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.UnionTypePanel;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TypeDialog
extends JDialog {
    private final TypeManager typeManager;
    private TypeDialogPanel currentPanel;
    private JTabbedPane tabbedPane;
    private final List<TypeDialogPanel> panels = Lists.newArrayList();
    private AtomicTypePanel atomicTypePanel;
    private PointerTypePanel pointerTypePanel;
    private ArrayTypePanel arrayTypePanel;
    private UnionTypePanel unionTypePanel;
    private StructureTypePanel structureTypePanel;
    private PrototypeTypePanel functionPrototypePanel;

    private TypeDialog(JFrame owner, TypeManager typeManager) {
        super(owner, "Create new type", true);
        this.typeManager = Preconditions.checkNotNull(typeManager, "IE02852: Type typeManager can not be null.");
        this.createControls(null);
        new CDialogEscaper(this);
    }

    private TypeDialog(JFrame owner, TypeManager typeManager, BaseType baseType) {
        super(owner, "Edit type", true);
        this.typeManager = Preconditions.checkNotNull(typeManager, "IE02853: Type typeManager can not be null.");
        this.createControls(baseType);
        new CDialogEscaper(this);
    }

    public static TypeDialog createBuildNewTypeDialog(JFrame owner, TypeManager manager) {
        return new TypeDialog(owner, manager);
    }

    public static TypeDialog createEditTypeDialog(JFrame owner, TypeManager manager, BaseType baseType) {
        return new TypeDialog(owner, manager, baseType);
    }

    private void createButtons() {
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new OkActionListener());
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TypeDialog.this.dispose();
            }
        });
        buttonPane.add(cancelButton);
    }

    private void createControls(BaseType baseType) {
        if (baseType == null) {
            this.atomicTypePanel = new AtomicTypePanel(this, this.typeManager);
            this.pointerTypePanel = new PointerTypePanel(this, this.typeManager);
            this.arrayTypePanel = new ArrayTypePanel(this, this.typeManager);
            this.structureTypePanel = new StructureTypePanel(this, this.typeManager);
            this.unionTypePanel = new UnionTypePanel(this, this.typeManager);
            this.functionPrototypePanel = new PrototypeTypePanel(this, this.typeManager);
        } else {
            switch (baseType.getCategory()) {
                case ATOMIC: {
                    this.atomicTypePanel = new AtomicTypePanel(this, this.typeManager, baseType);
                    break;
                }
                case POINTER: {
                    this.pointerTypePanel = new PointerTypePanel(this, this.typeManager, baseType);
                    break;
                }
                case ARRAY: {
                    this.arrayTypePanel = new ArrayTypePanel(this, this.typeManager, baseType);
                    break;
                }
                case STRUCT: {
                    this.structureTypePanel = new StructureTypePanel(this, this.typeManager, baseType);
                    break;
                }
                case UNION: {
                    this.unionTypePanel = new UnionTypePanel(this, this.typeManager, baseType);
                    break;
                }
                case FUNCTION_PROTOTYPE: {
                    this.functionPrototypePanel = new PrototypeTypePanel(this, this.typeManager, baseType);
                    break;
                }
                default: {
                    throw new IllegalStateException("IE02854: Unknown type category.");
                }
            }
        }
        this.tabbedPane = new JTabbedPane();
        this.addTab(this.atomicTypePanel, "Atomic type");
        this.addTab(this.pointerTypePanel, "Pointer type");
        this.addTab(this.arrayTypePanel, "Array type");
        this.addTab(this.structureTypePanel, "Structure type");
        this.addTab(this.unionTypePanel, "Union type");
        this.addTab(this.functionPrototypePanel, "Function prototype");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                JTabbedPane pane = (JTabbedPane)e2.getSource();
                TypeDialog.this.currentPanel = (TypeDialogPanel)TypeDialog.this.panels.get(pane.getSelectedIndex());
            }
        });
        this.setActivePanel(baseType);
        this.setBounds(100, 100, 516, 325);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.tabbedPane);
        this.createButtons();
    }

    private void addTab(TypeDialogPanel panel, String caption) {
        if (panel != null) {
            this.tabbedPane.add((Component)panel, caption);
            this.panels.add(panel);
        }
    }

    private void setActivePanel(BaseType baseType) {
        if (baseType == null) {
            this.currentPanel = this.atomicTypePanel;
            return;
        }
        switch (baseType.getCategory()) {
            case ATOMIC: {
                this.currentPanel = this.atomicTypePanel;
                break;
            }
            case POINTER: {
                this.currentPanel = this.pointerTypePanel;
                break;
            }
            case ARRAY: {
                this.currentPanel = this.arrayTypePanel;
                break;
            }
            case STRUCT: {
                this.currentPanel = this.structureTypePanel;
                break;
            }
            case UNION: {
                this.currentPanel = this.unionTypePanel;
                break;
            }
            case FUNCTION_PROTOTYPE: {
                this.currentPanel = this.functionPrototypePanel;
                break;
            }
            default: {
                String string2 = baseType.getCategory().toString();
                throw new IllegalStateException(new StringBuilder(54 + String.valueOf(string2).length()).append("Error: Base type: ").append(string2).append(" has no panel type associated to it.").toString());
            }
        }
        this.tabbedPane.setSelectedComponent(this.currentPanel);
    }

    private class OkActionListener
    implements ActionListener {
        private OkActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                if (TypeDialog.this.currentPanel.createOrUpdateType()) {
                    TypeDialog.this.dispose();
                }
            }
            catch (CouldntDeleteException | CouldntSaveDataException exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

