/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.ComplexTypePanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTable;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTableModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTableRowData;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Component;

public class StructureTypePanel
extends ComplexTypePanel {
    public StructureTypePanel(Component parent, TypeManager typeManager, BaseType existingType) {
        super(parent, typeManager, existingType);
    }

    public StructureTypePanel(Component parent, TypeManager typeManager) {
        this(parent, typeManager, null);
    }

    private static boolean isNonOverlappingMember(MemberTable members, int rowIndex) {
        MemberTableModel model = members.getModel();
        int modelIndex = members.convertRowIndexToModel(rowIndex);
        if (rowIndex + 1 < members.getRowCount()) {
            MemberTableRowData row = model.getRow(modelIndex);
            MemberTableRowData subsequentRow = model.getRow(members.convertRowIndexToModel(rowIndex + 1));
            if (row.getBaseType() == null) {
                return false;
            }
            if (subsequentRow.getIndex() < row.getIndex() + row.getBaseType().getByteSize()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void updateExistingType() throws CouldntDeleteException, CouldntSaveDataException {
        if (!this.existingType.getName().equals(this.name.getText())) {
            this.typeManager.renameType(this.existingType, this.name.getText());
        }
        this.createOrUpdateMembers(this.existingType, this.members.getModel());
    }

    @Override
    protected void createNewType() throws NumberFormatException, CouldntSaveDataException {
        this.createOrUpdateMembers(this.typeManager.createStructure(this.name.getText()), this.members.getModel());
    }

    @Override
    protected boolean validateTableRow(int rowIndex) {
        return super.validateTableRow(rowIndex) && StructureTypePanel.isNonOverlappingMember(this.members, rowIndex);
    }

    @Override
    protected boolean validateModel() {
        for (int i2 = 0; i2 < this.members.getModel().getRowCount(); ++i2) {
            if (this.validateTableRow(i2)) continue;
            CMessageBox.showError(this.parent, "Members must not overlap and need a valid name and base type.");
            return false;
        }
        if (this.name.getText().isEmpty()) {
            CMessageBox.showError(this.parent, "Please enter a valid name for the structure.");
            this.name.requestFocusInWindow();
            return false;
        }
        return true;
    }
}

