/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTable;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTableRowData;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

public class MemberTableMouseListener
extends MouseAdapter {
    private final MemberTable table;

    public MemberTableMouseListener(MemberTable table) {
        this.table = table;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
    }

    private void showPopup(MouseEvent event) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AddMemberAction());
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow != -1) {
            MemberTableRowData row = this.table.getModel().getRow(selectedRow);
            popupMenu.add(new InsertMemberBeforeAction(selectedRow, row.getName()));
            popupMenu.add(new InsertMemberAfterAction(selectedRow, row.getName()));
            popupMenu.add(new DeleteMemberAction(selectedRow, row.getName()));
        }
        popupMenu.show(event.getComponent(), event.getX(), event.getY());
    }

    private class DeleteMemberAction
    extends AbstractAction {
        private final int rowIndex;

        public DeleteMemberAction(int rowIndex, String memberName) {
            String string2 = String.valueOf(memberName);
            super(string2.length() != 0 ? "Delete member ".concat(string2) : new String("Delete member "));
            this.rowIndex = rowIndex;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MemberTableMouseListener.this.table.getModel().deleteRow(this.rowIndex);
        }
    }

    private class InsertMemberAfterAction
    extends AbstractAction {
        private final int rowIndex;

        public InsertMemberAfterAction(int rowIndex, String memberName) {
            String string2 = String.valueOf(memberName);
            super(string2.length() != 0 ? "Insert member after ".concat(string2) : new String("Insert member after "));
            this.rowIndex = rowIndex;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.rowIndex + 1 == MemberTableMouseListener.this.table.getModel().getRowCount()) {
                MemberTableMouseListener.this.table.getModel().addRow(new MemberTableRowData());
            } else {
                MemberTableMouseListener.this.table.getModel().addRow(this.rowIndex + 1);
            }
        }
    }

    private class InsertMemberBeforeAction
    extends AbstractAction {
        private final int rowIndex;

        public InsertMemberBeforeAction(int rowIndex, String memberName) {
            String string2 = String.valueOf(memberName);
            super(string2.length() != 0 ? "Insert member before ".concat(string2) : new String("Insert member before "));
            this.rowIndex = rowIndex;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MemberTableMouseListener.this.table.getModel().addRow(this.rowIndex);
        }
    }

    private class AddMemberAction
    extends AbstractAction {
        public AddMemberAction() {
            super("Add member");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MemberTableMouseListener.this.table.getModel().addRow(new MemberTableRowData());
        }
    }
}

