/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.BaseTypeTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TransferableBaseType;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TransferableMemberNodes;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeDataFlavor;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeMemberTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypesTree;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypesTreeModel;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class MemberNodeTransferHandler
extends TransferHandler {
    private final TypesTree typesTree;
    private List<TypeMemberTreeNode> selectedNodes;
    private final TypeManager typeManager;

    public MemberNodeTransferHandler(TypesTree typesTree, TypeManager typeManager) {
        this.typesTree = typesTree;
        this.typeManager = typeManager;
    }

    private static List<TypeMemberTreeNode> getSelectedNodesSorted(JTree tree) {
        ArrayList<TypeMemberTreeNode> nodes = Lists.newArrayList();
        for (TreePath path : tree.getSelectionPaths()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!(node instanceof TypeMemberTreeNode)) {
                return Lists.newArrayList();
            }
            nodes.add((TypeMemberTreeNode)node);
        }
        Collections.sort(nodes, new Comparator<TypeMemberTreeNode>(){

            @Override
            public int compare(TypeMemberTreeNode node0, TypeMemberTreeNode node1) {
                return node0.getTypeMember().compareTo(node1.getTypeMember());
            }
        });
        return nodes;
    }

    private int determineDestinationOffset(JTree.DropLocation location, BaseTypeTreeNode parentNode) {
        if (location.getChildIndex() == 0) {
            return 0;
        }
        if (location.getPath().getLastPathComponent() == this.typesTree.getModel().getRoot()) {
            return parentNode.getBaseType().getLastMember().getBitOffset().get();
        }
        TypeMember destinationMember = ((TypeMemberTreeNode)parentNode.getChildAt(location.getChildIndex() - 1)).getTypeMember();
        return destinationMember.getBitOffset().get();
    }

    private BaseTypeTreeNode determineParentNode(JTree.DropLocation location) {
        Object node = location.getPath().getLastPathComponent();
        if (node instanceof BaseTypeTreeNode) {
            return (BaseTypeTreeNode)node;
        }
        if (node == this.typesTree.getModel().getRoot() && location.getChildIndex() > 0) {
            return (BaseTypeTreeNode)this.typesTree.getModel().getChild(this.typesTree.getModel().getRoot(), location.getChildIndex() - 1);
        }
        return null;
    }

    private boolean isDropForbidden(TransferHandler.TransferSupport support2) {
        if (!support2.isDrop() || !(support2.getComponent() instanceof TypesTree)) {
            return true;
        }
        JTree.DropLocation location = (JTree.DropLocation)support2.getDropLocation();
        BaseTypeTreeNode destinationNode = this.determineParentNode(location);
        if (destinationNode != null && location.getChildIndex() != -1) {
            BaseType parentType = destinationNode.getBaseType();
            for (TypeMemberTreeNode memberNode : this.selectedNodes) {
                if (memberNode.getTypeMember().getParentType() == parentType) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected Transferable createTransferable(JComponent component) {
        List<TypeMemberTreeNode> nodes;
        TypesTree tree = (TypesTree)component;
        Object node = tree.getSelectionPath().getLastPathComponent();
        if (node instanceof BaseTypeTreeNode) {
            return new TransferableBaseType(((BaseTypeTreeNode)node).getBaseType());
        }
        if (node instanceof TypeMemberTreeNode && !(nodes = MemberNodeTransferHandler.getSelectedNodesSorted((TypesTree)component)).isEmpty()) {
            this.selectedNodes = nodes;
            return new TransferableMemberNodes(nodes);
        }
        return null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support2) {
        return support2.isDataFlavorSupported(TypeDataFlavor.TYPE_MEMBER_FLAVOR) && !this.isDropForbidden(support2);
    }

    @Override
    public int getSourceActions(JComponent component) {
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support2) {
        if (!support2.isDrop() || !this.canImport(support2)) {
            return false;
        }
        try {
            List draggedNodes = (List)support2.getTransferable().getTransferData(TypeDataFlavor.TYPE_MEMBER_FLAVOR);
            JTree.DropLocation location = this.typesTree.getDropLocation();
            TypesTree tree = (TypesTree)support2.getComponent();
            TypesTreeModel model = tree.getModel();
            int[] selectedRows = new int[tree.getSelectionCount()];
            int row = 0;
            BaseTypeTreeNode parentNode = this.determineParentNode(location);
            for (TypeMemberTreeNode typeMemberTreeNode : MemberNodeTransferHandler.getSelectedNodesSorted(tree)) {
                selectedRows[row++] = model.getIndexOfChild(parentNode, typeMemberTreeNode);
            }
            ArrayList<TypeMember> draggedMembers = Lists.newArrayList();
            for (TypeMemberTreeNode node : draggedNodes) {
                draggedMembers.add(node.getTypeMember());
            }
            int n2 = this.determineDestinationOffset(location, parentNode) - ((TypeMember)draggedMembers.get(0)).getBitOffset().get();
            this.typeManager.moveMembers(parentNode.getBaseType(), draggedMembers, n2);
        }
        catch (CouldntSaveDataException | UnsupportedFlavorException | IOException exception) {
            CUtilityFunctions.logException(exception);
            return false;
        }
        return true;
    }
}

