/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeComboBox;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeListModel;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class MemberDialog
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    private JTextField memberName;
    private boolean wasCanceled = true;
    private TypeComboBox memberType;

    private MemberDialog(JFrame owner, TypeManager typeManager) {
        super((Frame)owner, true);
        this.createControls(typeManager);
    }

    private MemberDialog(JFrame owner, TypeManager typeManager, TypeMember member) {
        super((Frame)owner, true);
        this.createControls(typeManager);
        this.populateControls(member);
    }

    public static MemberDialog createBuildNewMemberDialog(JFrame owner, TypeManager typeManager) {
        return new MemberDialog(owner, typeManager);
    }

    public static MemberDialog createEditMemberDialog(JFrame owner, TypeManager typeManager, TypeMember member) {
        return new MemberDialog(owner, typeManager, member);
    }

    private void createControls(TypeManager typeManager) {
        this.setBounds(100, 100, 450, 215);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        GridBagLayout gbl_contentPanel = new GridBagLayout();
        gbl_contentPanel.columnWidths = new int[]{0, 0, 0};
        gbl_contentPanel.rowHeights = new int[]{0, 0, 0, 0};
        gbl_contentPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_contentPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPanel.setLayout(gbl_contentPanel);
        JLabel lblMemberName = new JLabel("Member name:");
        GridBagConstraints gbc_lblMemberName = new GridBagConstraints();
        gbc_lblMemberName.insets = new Insets(0, 0, 5, 5);
        gbc_lblMemberName.anchor = 13;
        gbc_lblMemberName.gridx = 0;
        gbc_lblMemberName.gridy = 0;
        this.contentPanel.add((Component)lblMemberName, gbc_lblMemberName);
        this.memberName = new JTextField();
        GridBagConstraints gbc_memberName = new GridBagConstraints();
        gbc_memberName.insets = new Insets(0, 0, 5, 0);
        gbc_memberName.fill = 2;
        gbc_memberName.gridx = 1;
        gbc_memberName.gridy = 0;
        this.contentPanel.add((Component)this.memberName, gbc_memberName);
        this.memberName.setColumns(10);
        JLabel lblMemberType = new JLabel("Member type:");
        GridBagConstraints gbc_lblMemberType = new GridBagConstraints();
        gbc_lblMemberType.anchor = 13;
        gbc_lblMemberType.insets = new Insets(0, 0, 5, 5);
        gbc_lblMemberType.gridx = 0;
        gbc_lblMemberType.gridy = 1;
        this.contentPanel.add((Component)lblMemberType, gbc_lblMemberType);
        this.memberType = new TypeComboBox(new TypeListModel(typeManager.getTypes(), new TypeListModel.PrototypesFilter()));
        GridBagConstraints gbc_memberType = new GridBagConstraints();
        gbc_memberType.insets = new Insets(0, 0, 5, 0);
        gbc_memberType.fill = 2;
        gbc_memberType.gridx = 1;
        gbc_memberType.gridy = 1;
        this.contentPanel.add((Component)this.memberType, gbc_memberType);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new OkActionListener());
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                MemberDialog.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }

    private void populateControls(TypeMember member) {
        this.memberName.setText(member.getName());
        this.memberType.getModel().selectByBaseType(member.getBaseType());
    }

    public BaseType getBaseType() {
        return (BaseType)this.memberType.getModel().getSelectedItem();
    }

    public String getMemberName() {
        return this.memberName.getText();
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    private class OkActionListener
    implements ActionListener {
        private OkActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (MemberDialog.this.getBaseType() == null) {
                CMessageBox.showWarning(MemberDialog.this, "Please select a base type.");
                return;
            }
            if (MemberDialog.this.getMemberName().isEmpty()) {
                CMessageBox.showWarning(MemberDialog.this, "Please enter a name for the member.");
                return;
            }
            MemberDialog.this.wasCanceled = false;
            MemberDialog.this.dispose();
        }
    }
}

