/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeEditor;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class DeleteTypeAction
extends AbstractAction {
    private final JFrame owner;
    private final TypeEditor typeEditor;
    private final TypeManager typeManager;

    public DeleteTypeAction(JFrame owner, TypeManager typeManager, TypeEditor typeEditor) {
        super("Delete type");
        this.owner = owner;
        this.typeManager = typeManager;
        this.typeEditor = typeEditor;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ImmutableList<BaseType> types2 = this.typeEditor.getSelectedTypes();
        if (types2.isEmpty() || CMessageBox.showYesNoQuestion(this.owner, "Do you really want to delete these type(s)?") != 0) {
            return;
        }
        try {
            for (BaseType baseType : types2) {
                this.typeManager.deleteType(baseType);
            }
        }
        catch (CouldntDeleteException exception) {
            CUtilityFunctions.logException(exception);
        }
    }
}

