/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeEditor;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class DeleteMemberAction
extends AbstractAction {
    private final JFrame owner;
    private final TypeEditor typeEditor;
    private final TypeManager typeManager;

    public DeleteMemberAction(JFrame owner, TypeManager typeManager, TypeEditor typeEditor) {
        super("Delete member");
        this.owner = owner;
        this.typeManager = typeManager;
        this.typeEditor = typeEditor;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ImmutableList<TypeMember> members = this.typeEditor.getSelectedMembers();
        if (members.isEmpty() || CMessageBox.showYesNoQuestion(this.owner, "Do you really want to delete these member(s)?") != 0) {
            return;
        }
        try {
            for (TypeMember member : members) {
                this.typeManager.deleteMember(member);
            }
        }
        catch (CouldntDeleteException | CouldntSaveDataException exception) {
            CUtilityFunctions.logException(exception);
        }
    }
}

