/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.types.DragAndDropSupportWrapper;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.TransferHandler;

public class BaseTypeTransferHandler
extends TransferHandler {
    private final TypeManager typeManager;
    private final DragAndDropSupportWrapper wrapper;

    public BaseTypeTransferHandler(TypeManager typeManager, DragAndDropSupportWrapper wrapper) {
        this.typeManager = typeManager;
        this.wrapper = wrapper;
    }

    private static boolean isLegalDropNode(INaviOperandTreeNode node) {
        return node != null && node.getType() == ExpressionType.REGISTER && BaseTypeTransferHandler.isSubstitutableExpression(node);
    }

    private static boolean isSubstitutableExpression(INaviOperandTreeNode node) {
        return node.getChildren().size() == 0 || node.hasAddendSibling() && node.determineAddendValue() >= 0L;
    }

    private boolean createOrUpdateTypeSubstitution(DragAndDropSupportWrapper wrapper) throws UnsupportedFlavorException, IOException, CouldntSaveDataException {
        INaviOperandTreeNode node = wrapper.determineDropNode();
        if (!BaseTypeTransferHandler.isLegalDropNode(node)) {
            return false;
        }
        BaseType baseType = wrapper.getDroppedBaseType();
        if (node.getTypeSubstitution() != null) {
            this.typeManager.updateTypeSubstitution(node, node.getTypeSubstitution(), baseType, new ArrayList<TypeMember>(), 0);
        } else {
            this.typeManager.createTypeSubstitution(node, baseType, node.getOperandPosition(), 0, node.getInstructionAddress());
        }
        return true;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support2) {
        this.wrapper.setSupport(support2);
        return this.wrapper.acceptDrop();
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support2) {
        this.wrapper.setSupport(support2);
        if (!this.wrapper.acceptDrop()) {
            return false;
        }
        try {
            return this.createOrUpdateTypeSubstitution(this.wrapper);
        }
        catch (CouldntSaveDataException | UnsupportedFlavorException | IOException exception) {
            CUtilityFunctions.logException(exception);
            return false;
        }
    }
}

