/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Toolbar;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionCircularLayout;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionColorNodes;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionDeleteSelectedNodes;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionDeleteSelectedNodesKeep;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionFreezeView;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionHierarchicLayout;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionInvertSelection;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionMagnifyingGlassViewMode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionOrthogonalLayout;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionSelectByCriteria;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionSelectChildren;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionSelectParents;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionZoomFit;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionZoomIn;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionZoomOut;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Actions.CActionZoomSelected;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Goto.CGotoAddressField;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Gui.CGraphSearchPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Toolbar.CGraphToolBarNavigationPanel;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IDisplaySettingsListener;
import java.awt.Insets;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public final class CGraphToolBar
extends JToolBar {
    private static final long serialVersionUID = 6849359199616953169L;
    private final ZyGraphViewSettings m_settings;
    private final CGraphToolBarNavigationPanel m_navigationPanel;
    private CActionMagnifyingGlassViewMode m_magnifierModeAction;
    private final InternalListener m_internalListener = new InternalListener();

    public CGraphToolBar(JFrame parent, CGraphPanel graphPanel, ZyGraph graph, List<INaviModule> modules) {
        Preconditions.checkNotNull(parent, "IE01622: Parent argument can not be null");
        Preconditions.checkNotNull(graph, "IE01623: Graph argument can not be null");
        Preconditions.checkNotNull(graphPanel, "IE01624: Action provider argument can't be null");
        this.m_settings = graph.getSettings();
        this.createButtons(parent, graph, graphPanel);
        this.m_navigationPanel = new CGraphToolBarNavigationPanel(graph, modules, parent);
        this.add(this.m_navigationPanel);
        this.setFloatable(false);
        this.m_settings.getDisplaySettings().addListener(this.m_internalListener);
    }

    private static void addHotkey(JButton button, KeyStroke keyStroke, AbstractAction action, String name) {
        InputMap windowImap = button.getInputMap(2);
        windowImap.put(keyStroke, name);
        button.getActionMap().put(name, action);
    }

    private JButton addButton(AbstractAction action, String rolloverIcon, String pressedIcon) {
        JButton button = this.add(CActionProxy.proxy(action));
        button.setFocusable(false);
        button.setBorder(new EmptyBorder(new Insets(1, 0, 1, 0)));
        button.setRolloverIcon(new ImageIcon(CMain.class.getResource(rolloverIcon)));
        button.setPressedIcon(new ImageIcon(CMain.class.getResource(pressedIcon)));
        return button;
    }

    private void createButtons(JFrame parent, ZyGraph graph, CGraphPanel graphPanel) {
        CActionZoomIn zoomInAction = new CActionZoomIn(graph);
        JButton zoomInButton = this.addButton(zoomInAction, "data/magnify_hover.jpg", "data/magnify_down.jpg");
        CGraphToolBar.addHotkey(zoomInButton, HotKeys.GRAPH_TOOLBAR_ZOOM_IN.getKeyStroke(), zoomInAction, "Zoom In");
        CActionZoomOut zoomOutAction = new CActionZoomOut(graph);
        JButton zoomOutButton = this.addButton(zoomOutAction, "data/reduce_hover.jpg", "data/reduce_down.jpg");
        CGraphToolBar.addHotkey(zoomOutButton, HotKeys.GRAPH_TOOLBAR_ZOOM_OUT.getKeyStroke(), zoomOutAction, "Zoom Out");
        CActionZoomSelected zoomSelectedAction = new CActionZoomSelected(graph);
        JButton zoomSelectedButton = this.addButton(zoomSelectedAction, "data/frameall_hover.jpg", "data/frameall_down.jpg");
        CGraphToolBar.addHotkey(zoomSelectedButton, HotKeys.GRAPH_TOOLBAR_ZOOM_SELECTED.getKeyStroke(), zoomSelectedAction, "Zoom Selected");
        CActionZoomFit zoomFitAction = new CActionZoomFit(graph);
        JButton zoomFitButton = this.addButton(zoomFitAction, "data/centerview_hover.jpg", "data/centerview_down.jpg");
        CGraphToolBar.addHotkey(zoomFitButton, HotKeys.GRAPH_TOOLBAR_ZOOM_FIT.getKeyStroke(), zoomFitAction, "Fit Graph to Screen");
        this.m_magnifierModeAction = new CActionMagnifyingGlassViewMode(graph);
        JButton magnifierModeButton = this.addButton(this.m_magnifierModeAction, "data/nomagnifieingglass_hover.jpg", "data/nomagnifieingglass_down.jpg");
        this.m_magnifierModeAction.setButton(magnifierModeButton);
        CGraphToolBar.addHotkey(magnifierModeButton, HotKeys.GRAPH_TOOLBAR_TOGGLE_MAGNIFY.getKeyStroke(), this.m_magnifierModeAction, "Magnifying Glass");
        CActionFreezeView freezeAction = new CActionFreezeView(graph);
        JButton freezeButton = this.addButton(freezeAction, "data/viewnavi_hover.jpg", "data/viewnavi_down.jpg");
        freezeAction.setButton(freezeButton);
        CGraphToolBar.addHotkey(freezeButton, HotKeys.GRAPH_TOOLBAR_FREEZE.getKeyStroke(), freezeAction, "Freeze view");
        CActionCircularLayout circularAction = new CActionCircularLayout(parent, graph);
        JButton circularButton = this.addButton(circularAction, "data/laycirc_hover.jpg", "data/laycirc_down.jpg");
        CGraphToolBar.addHotkey(circularButton, HotKeys.GRAPH_TOOLBAR_CIRCULAR_LAYOUT.getKeyStroke(), circularAction, "Circular Layout");
        CActionOrthogonalLayout orthogonalAction = new CActionOrthogonalLayout(parent, graph);
        JButton orthogonalButton = this.addButton(orthogonalAction, "data/layorth_hover.jpg", "data/layorth_down.jpg");
        CGraphToolBar.addHotkey(orthogonalButton, HotKeys.GRAPH_TOOLBAR_ORTHOGONAL_LAYOUT.getKeyStroke(), orthogonalAction, "Orthogonal Layout");
        CActionHierarchicLayout hierarchicAction = new CActionHierarchicLayout(parent, graph);
        JButton hierarchicButton = this.addButton(hierarchicAction, "data/layhier_hover.jpg", "data/layhier_down.jpg");
        CGraphToolBar.addHotkey(hierarchicButton, HotKeys.GRAPH_TOOLBAR_HIERARCHIC_LAYOUT.getKeyStroke(), hierarchicAction, "Hierarchical Layout");
        this.addButton(new CActionSelectChildren(graph, true), "data/selallchild_hover.jpg", "data/selallchild_down.jpg");
        this.addButton(new CActionSelectParents(graph, true), "data/selparent_hover.jpg", "data/selparent_down.jpg");
        this.addButton(new CActionInvertSelection(graph, true), "data/selinvert_hover.jpg", "data/selinvert_down.jpg");
        this.addButton(new CActionSelectByCriteria(graphPanel, true), "data/selcriteria_hover.jpg", "data/selcriteria_down.jpg");
        CActionDeleteSelectedNodes deleteSelectedAction = new CActionDeleteSelectedNodes(graph, true);
        JButton deletedSelectedButton = this.addButton(deleteSelectedAction, "data/deleteselectednodes_hover.png", "data/deleteselectednodes_down.png");
        CGraphToolBar.addHotkey(deletedSelectedButton, HotKeys.GRAPH_TOOLBAR_DELETE_SELECTED.getKeyStroke(), deleteSelectedAction, HotKeys.GRAPH_TOOLBAR_DELETE_SELECTED.getDescription());
        CActionDeleteSelectedNodesKeep deleteSelectedKeepAction = new CActionDeleteSelectedNodesKeep(graph);
        JButton deletedSelectedKeepButton = this.addButton(deleteSelectedKeepAction, "data/deleteselectednodeskeepedges_hover.png", "data/deleteselectednodeskeepedges_down.png");
        CGraphToolBar.addHotkey(deletedSelectedKeepButton, HotKeys.GRAPH_TOOLBAR_DELETE_SELECTED_KEEP_EDGES.getKeyStroke(), deleteSelectedKeepAction, HotKeys.GRAPH_TOOLBAR_DELETE_SELECTED_KEEP_EDGES.getDescription());
        this.addButton(new CActionColorNodes(graphPanel), "data/nodecolor_hover.jpg", "data/nodecolor_down.jpg");
    }

    public void dispose() {
        this.m_settings.getDisplaySettings().removeListener(this.m_internalListener);
        this.m_navigationPanel.dispose();
    }

    public CGotoAddressField getGotoAddressField() {
        return this.m_navigationPanel.getGotoAddressField();
    }

    public CGraphSearchPanel getSearchPanel() {
        return this.m_navigationPanel.getSearchPanel();
    }

    private class InternalListener
    implements IDisplaySettingsListener {
        private InternalListener() {
        }

        @Override
        public void changedMagnifyingGlass(boolean value) {
            CGraphToolBar.this.m_magnifierModeAction.updateButton();
        }
    }
}

