/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Goto;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Goto.CAddressSelectionDialog;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Goto.CGotoAddressInputField;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.ZyZoomHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.comboboxes.memorybox.JMemoryBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public final class CGotoAddressField
extends JMemoryBox {
    private static final long serialVersionUID = -944210249806692638L;
    private final ZyGraph m_graph;
    private final List<INaviModule> m_modules;
    private final JFrame m_parent;
    private final InternalActionListener m_listener = new InternalActionListener();
    private final CGotoAddressInputField m_textField = new CGotoAddressInputField();

    public CGotoAddressField(ZyGraph graph, List<INaviModule> modules, JFrame parent) {
        super(20);
        this.m_graph = Preconditions.checkNotNull(graph, "IE01811: Graph argument can't be null");
        this.m_modules = Preconditions.checkNotNull(modules, "IE01176: Modules argument can not be null");
        this.m_parent = Preconditions.checkNotNull(parent, "IE02845: parent argument can not be null");
        this.m_textField.setPreferredSize(this.getPreferredSize());
        this.m_textField.setBorder(((JTextField)new JComboBox().getEditor().getEditorComponent()).getBorder());
        this.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                return CGotoAddressField.this.m_textField;
            }
        });
        ((JTextField)this.getEditor().getEditorComponent()).getInputMap().put(HotKeys.GRAPH_SEARCH_NEXT_KEY.getKeyStroke(), "ZOOM");
        ((JTextField)this.getEditor().getEditorComponent()).getActionMap().put("ZOOM", new AbstractAction(){
            private static final long serialVersionUID = 4721578747969744911L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (CGotoAddressField.this.m_modules.size() == 1) {
                    CGotoAddressField.this.zoomToAddress();
                } else {
                    CGotoAddressField.this.buildAddressSelectionPopUp();
                }
            }
        });
        this.addActionListener(this.m_listener);
    }

    private void buildAddressSelectionPopUp() {
        CAddressSelectionDialog dlg = new CAddressSelectionDialog(this.m_parent, this.m_modules);
        dlg.setVisible(true);
        INaviModule result = dlg.getSelectionResult();
        CAddress address = new CAddress(Long.parseLong(this.getText(), 16));
        ZyZoomHelpers.zoomToAddress(this.m_graph, (IAddress)address, result, true);
    }

    private String getText() {
        return ((JTextField)this.getEditor().getEditorComponent()).getText();
    }

    private void zoomToAddress() {
        if (!"".equals(this.getText())) {
            this.add(this.getText());
            CAddress address = new CAddress(Long.parseLong(this.getText(), 16));
            this.m_textField.setSuccessful(ZyZoomHelpers.zoomToAddress(this.m_graph, (IAddress)address, this.m_modules.get(0), true));
        }
    }

    private class InternalActionListener
    implements ActionListener {
        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CGotoAddressField.this.zoomToAddress();
        }
    }
}

