/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.Right;

import com.google.security.zynamics.binnavi.Gui.Debug.OptionsPanel.COptionsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTaggingPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagsTree;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IPerspectiveModelListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.PerspectiveType;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeEditorPanel;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultTreeSelectionModel;

public final class CCombinedRightPanel
extends JPanel {
    private final CGraphModel model;
    private final CPerspectiveModel perspectiveModel;
    private final CTaggingPanel taggingPanel;
    private final JPanel debugPerspectivePanel;
    private final IPerspectiveModelListener m_listener = new InternalPerspectiveListener();

    public CCombinedRightPanel(JFrame parent, CGraphModel model, CPerspectiveModel perspectiveModel) {
        super(new BorderLayout());
        this.model = model;
        this.perspectiveModel = perspectiveModel;
        TypeManager typeManager = model.getViewContainer().getModules().get(0).getTypeManager();
        this.taggingPanel = new CTaggingPanel(parent, model.getGraph(), model.getDatabase().getContent().getNodeTagManager());
        JSplitPane taggingSplitPane = new JSplitPane(0, this.taggingPanel, CCombinedRightPanel.createTypePanels(parent, model, typeManager));
        taggingSplitPane.setOneTouchExpandable(true);
        this.add(taggingSplitPane);
        this.debugPerspectivePanel = new JPanel(new BorderLayout());
        this.add((Component)this.debugPerspectivePanel, "South");
        perspectiveModel.addListener(this.m_listener);
        this.debugPerspectivePanel.setVisible(false);
    }

    private static JPanel createTypePanels(JFrame parent, CGraphModel model, TypeManager typeManager) {
        JPanel typePanel = new JPanel(new BorderLayout());
        TypeEditorPanel typeEditorPanel = TypeEditorPanel.CreateDefaultTypeEditor(parent, typeManager);
        if (CCombinedRightPanel.isFunctionFlowgraph(model)) {
            JSplitPane splitPaneTop = new JSplitPane(0);
            splitPaneTop.setBorder(BorderFactory.createEmptyBorder());
            splitPaneTop.setOneTouchExpandable(true);
            JSplitPane splitPaneBottom = new JSplitPane(0);
            splitPaneBottom.setBorder(BorderFactory.createEmptyBorder());
            splitPaneBottom.setOneTouchExpandable(true);
            splitPaneTop.setTopComponent(CCombinedRightPanel.createPrototypePanel(parent, model, typeManager));
            splitPaneTop.setBottomComponent(CCombinedRightPanel.createStackFramePanel(parent, model, typeManager));
            splitPaneBottom.setTopComponent(splitPaneTop);
            splitPaneBottom.setBottomComponent(typeEditorPanel);
            typePanel.add(splitPaneBottom);
        } else {
            typePanel.add((Component)typeEditorPanel, "Center");
        }
        return typePanel;
    }

    private static boolean isFunctionFlowgraph(CGraphModel model) {
        return model.getGraph().getRawView().getContent().getGraphType().equals((Object)GraphType.FLOWGRAPH) && model.getViewContainer().getFunction(model.getGraph().getRawView()) != null;
    }

    private static JPanel createStackFramePanel(JFrame parent, CGraphModel model, TypeManager typeManager) {
        JPanel stackFramePanel = new JPanel(new BorderLayout());
        stackFramePanel.add((Component)TypeEditorPanel.CreateStackFrameEditor(parent, typeManager, model.getViewContainer().getFunction(model.getGraph().getRawView())), "Center");
        return stackFramePanel;
    }

    private static JPanel createPrototypePanel(JFrame parent, CGraphModel model, TypeManager typeManager) {
        JPanel prototypePanel = new JPanel(new BorderLayout());
        prototypePanel.add((Component)TypeEditorPanel.CreatePrototypeEditor(parent, typeManager, model.getViewContainer().getFunction(model.getGraph().getRawView())), "Center");
        return prototypePanel;
    }

    private CDebugPerspectiveModel getDebugPerspective() {
        return (CDebugPerspectiveModel)this.perspectiveModel.getModel(PerspectiveType.DebugPerspective);
    }

    public void dispose() {
        this.taggingPanel.getTree().dispose();
        this.taggingPanel.getTree().setSelectionModel(new DefaultTreeSelectionModel());
    }

    public CTagsTree getTree() {
        return this.taggingPanel.getTree();
    }

    private class InternalPerspectiveListener
    implements IPerspectiveModelListener {
        private InternalPerspectiveListener() {
        }

        @Override
        public void changedActivePerspective(PerspectiveType activeView) {
            if (activeView == PerspectiveType.DebugPerspective && CCombinedRightPanel.this.getDebugPerspective().getCurrentSelectedDebugger() != null) {
                COptionsPanel optionsPanel = new COptionsPanel(CCombinedRightPanel.this.model.getParent(), CCombinedRightPanel.this.model.getDebuggerProvider().getDebugTarget(), CCombinedRightPanel.this.model.getGraph(), CCombinedRightPanel.this.getDebugPerspective());
                CCombinedRightPanel.this.debugPerspectivePanel.add(optionsPanel);
            } else {
                CCombinedRightPanel.this.debugPerspectivePanel.removeAll();
            }
            CCombinedRightPanel.this.debugPerspectivePanel.setVisible(activeView == PerspectiveType.DebugPerspective);
        }
    }
}

