/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.Left;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IPerspectiveModelListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.Left.Debug.CDebugLeftPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.Left.Standard.CStandardLeftPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.PerspectiveType;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Gui.CGraphSearchField;
import java.awt.BorderLayout;
import javax.swing.JPanel;

public final class CCombinedLeftPanel
extends JPanel {
    private static final long serialVersionUID = -4794578753327568747L;
    private final CStandardLeftPanel m_leftPanel;
    private final CDebugLeftPanel m_debugLeftPanel;
    private final CPerspectiveModel m_perspectiveModel;
    private final IPerspectiveModelListener m_listener = new InternalPerspectiveListener();

    public CCombinedLeftPanel(CGraphModel model, CPerspectiveModel perspectiveModel, CGraphSearchField searchField) {
        super(new BorderLayout());
        this.m_perspectiveModel = perspectiveModel;
        this.m_leftPanel = new CStandardLeftPanel(model.getGraph(), model.getSelectionHistory(), searchField);
        this.m_debugLeftPanel = new CDebugLeftPanel(model.getParent(), model.getDebuggerProvider(), (CDebugPerspectiveModel)perspectiveModel.getModel(PerspectiveType.DebugPerspective));
        this.add(this.m_leftPanel);
        perspectiveModel.addListener(this.m_listener);
    }

    public void dispose() {
        this.m_perspectiveModel.removeListener(this.m_listener);
        this.m_leftPanel.delete();
        this.m_debugLeftPanel.dispose();
    }

    private class InternalPerspectiveListener
    implements IPerspectiveModelListener {
        private InternalPerspectiveListener() {
        }

        @Override
        public void changedActivePerspective(PerspectiveType activeView) {
            CCombinedLeftPanel.this.removeAll();
            if (activeView == PerspectiveType.DebugPerspective) {
                CCombinedLeftPanel.this.add(CCombinedLeftPanel.this.m_debugLeftPanel);
            } else {
                CCombinedLeftPanel.this.add(CCombinedLeftPanel.this.m_leftPanel);
            }
            CCombinedLeftPanel.this.updateUI();
        }
    }
}

